package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class LocalizableEnumTypeDraft {
  private List<LocalizedEnumValueDraft> values;

  public LocalizableEnumTypeDraft() {
  }

  public LocalizableEnumTypeDraft(List<LocalizedEnumValueDraft> values) {
    this.values = values;
  }

  public List<LocalizedEnumValueDraft> getValues() {
    return values;
  }

  public void setValues(List<LocalizedEnumValueDraft> values) {
    this.values = values;
  }

  @Override
  public String toString() {
    return "LocalizableEnumTypeDraft{values='" + values + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizableEnumTypeDraft that = (LocalizableEnumTypeDraft) o;
    return Objects.equals(values, that.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedEnumValueDraft> values;

    public LocalizableEnumTypeDraft build() {
      LocalizableEnumTypeDraft result = new LocalizableEnumTypeDraft();
      result.values = this.values;
      return result;
    }

    public Builder values(List<LocalizedEnumValueDraft> values) {
      this.values = values;
      return this;
    }
  }
}
