package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class LocalizedEnumType implements com.commercetools.graphql.api.types.FieldType {
  private List<LocalizedEnumValue> values;

  private String name;

  public LocalizedEnumType() {
  }

  public LocalizedEnumType(List<LocalizedEnumValue> values, String name) {
    this.values = values;
    this.name = name;
  }

  public List<LocalizedEnumValue> getValues() {
    return values;
  }

  public void setValues(List<LocalizedEnumValue> values) {
    this.values = values;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "LocalizedEnumType{values='" + values + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizedEnumType that = (LocalizedEnumType) o;
    return Objects.equals(values, that.values) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(values, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedEnumValue> values;

    private String name;

    public LocalizedEnumType build() {
      LocalizedEnumType result = new LocalizedEnumType();
      result.values = this.values;
      result.name = this.name;
      return result;
    }

    public Builder values(List<LocalizedEnumValue> values) {
      this.values = values;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
