package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class LocalizedString {
  private String locale;

  private String value;

  public LocalizedString() {
  }

  public LocalizedString(String locale, String value) {
    this.locale = locale;
    this.value = value;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "LocalizedString{locale='" + locale + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalizedString that = (LocalizedString) o;
    return Objects.equals(locale, that.locale) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String locale;

    private String value;

    public LocalizedString build() {
      LocalizedString result = new LocalizedString();
      result.locale = this.locale;
      result.value = this.value;
      return result;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
