package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Message implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String id;

  private String type;

  private Long sequenceNumber;

  private Reference resourceRef;

  private Long resourceVersion;

  private UserProvidedIdentifiers userProvidedIdentifiers;

  private MessagePayload payload;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Message() {
  }

  public Message(String id, String type, Long sequenceNumber, Reference resourceRef,
      Long resourceVersion, UserProvidedIdentifiers userProvidedIdentifiers, MessagePayload payload,
      Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.id = id;
    this.type = type;
    this.sequenceNumber = sequenceNumber;
    this.resourceRef = resourceRef;
    this.resourceVersion = resourceVersion;
    this.userProvidedIdentifiers = userProvidedIdentifiers;
    this.payload = payload;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Long getSequenceNumber() {
    return sequenceNumber;
  }

  public void setSequenceNumber(Long sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
  }

  public Reference getResourceRef() {
    return resourceRef;
  }

  public void setResourceRef(Reference resourceRef) {
    this.resourceRef = resourceRef;
  }

  public Long getResourceVersion() {
    return resourceVersion;
  }

  public void setResourceVersion(Long resourceVersion) {
    this.resourceVersion = resourceVersion;
  }

  public UserProvidedIdentifiers getUserProvidedIdentifiers() {
    return userProvidedIdentifiers;
  }

  public void setUserProvidedIdentifiers(UserProvidedIdentifiers userProvidedIdentifiers) {
    this.userProvidedIdentifiers = userProvidedIdentifiers;
  }

  public MessagePayload getPayload() {
    return payload;
  }

  public void setPayload(MessagePayload payload) {
    this.payload = payload;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Message{id='" + id + "', type='" + type + "', sequenceNumber='" + sequenceNumber + "', resourceRef='" + resourceRef + "', resourceVersion='" + resourceVersion + "', userProvidedIdentifiers='" + userProvidedIdentifiers + "', payload='" + payload + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Message that = (Message) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(type, that.type) &&
        Objects.equals(sequenceNumber, that.sequenceNumber) &&
        Objects.equals(resourceRef, that.resourceRef) &&
        Objects.equals(resourceVersion, that.resourceVersion) &&
        Objects.equals(userProvidedIdentifiers, that.userProvidedIdentifiers) &&
        Objects.equals(payload, that.payload) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, sequenceNumber, resourceRef, resourceVersion, userProvidedIdentifiers, payload, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String type;

    private Long sequenceNumber;

    private Reference resourceRef;

    private Long resourceVersion;

    private UserProvidedIdentifiers userProvidedIdentifiers;

    private MessagePayload payload;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Message build() {
      Message result = new Message();
      result.id = this.id;
      result.type = this.type;
      result.sequenceNumber = this.sequenceNumber;
      result.resourceRef = this.resourceRef;
      result.resourceVersion = this.resourceVersion;
      result.userProvidedIdentifiers = this.userProvidedIdentifiers;
      result.payload = this.payload;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder sequenceNumber(Long sequenceNumber) {
      this.sequenceNumber = sequenceNumber;
      return this;
    }

    public Builder resourceRef(Reference resourceRef) {
      this.resourceRef = resourceRef;
      return this;
    }

    public Builder resourceVersion(Long resourceVersion) {
      this.resourceVersion = resourceVersion;
      return this;
    }

    public Builder userProvidedIdentifiers(UserProvidedIdentifiers userProvidedIdentifiers) {
      this.userProvidedIdentifiers = userProvidedIdentifiers;
      return this;
    }

    public Builder payload(MessagePayload payload) {
      this.payload = payload;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
