package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class MessageSubscription {
  private String resourceTypeId;

  private List<String> types;

  public MessageSubscription() {
  }

  public MessageSubscription(String resourceTypeId, List<String> types) {
    this.resourceTypeId = resourceTypeId;
    this.types = types;
  }

  public String getResourceTypeId() {
    return resourceTypeId;
  }

  public void setResourceTypeId(String resourceTypeId) {
    this.resourceTypeId = resourceTypeId;
  }

  public List<String> getTypes() {
    return types;
  }

  public void setTypes(List<String> types) {
    this.types = types;
  }

  @Override
  public String toString() {
    return "MessageSubscription{resourceTypeId='" + resourceTypeId + "', types='" + types + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageSubscription that = (MessageSubscription) o;
    return Objects.equals(resourceTypeId, that.resourceTypeId) &&
        Objects.equals(types, that.types);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceTypeId, types);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String resourceTypeId;

    private List<String> types;

    public MessageSubscription build() {
      MessageSubscription result = new MessageSubscription();
      result.resourceTypeId = this.resourceTypeId;
      result.types = this.types;
      return result;
    }

    public Builder resourceTypeId(String resourceTypeId) {
      this.resourceTypeId = resourceTypeId;
      return this;
    }

    public Builder types(List<String> types) {
      this.types = types;
      return this;
    }
  }
}
