package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MethodTaxRate {
  private String shippingMethodKey;

  private TaxRate taxRate;

  public MethodTaxRate() {
  }

  public MethodTaxRate(String shippingMethodKey, TaxRate taxRate) {
    this.shippingMethodKey = shippingMethodKey;
    this.taxRate = taxRate;
  }

  public String getShippingMethodKey() {
    return shippingMethodKey;
  }

  public void setShippingMethodKey(String shippingMethodKey) {
    this.shippingMethodKey = shippingMethodKey;
  }

  public TaxRate getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRate taxRate) {
    this.taxRate = taxRate;
  }

  @Override
  public String toString() {
    return "MethodTaxRate{shippingMethodKey='" + shippingMethodKey + "', taxRate='" + taxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MethodTaxRate that = (MethodTaxRate) o;
    return Objects.equals(shippingMethodKey, that.shippingMethodKey) &&
        Objects.equals(taxRate, that.taxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethodKey, taxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingMethodKey;

    private TaxRate taxRate;

    public MethodTaxRate build() {
      MethodTaxRate result = new MethodTaxRate();
      result.shippingMethodKey = this.shippingMethodKey;
      result.taxRate = this.taxRate;
      return result;
    }

    public Builder shippingMethodKey(String shippingMethodKey) {
      this.shippingMethodKey = shippingMethodKey;
      return this;
    }

    public Builder taxRate(TaxRate taxRate) {
      this.taxRate = taxRate;
      return this;
    }
  }
}
