package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Money implements com.commercetools.graphql.api.types.BaseMoney {
  private String type;

  private Currency currencyCode;

  private Long centAmount;

  /**
   * For the `Money` it equals to the default number of fraction digits used with the currency.
   */
  private Integer fractionDigits;

  public Money() {
  }

  public Money(String type, Currency currencyCode, Long centAmount, Integer fractionDigits) {
    this.type = type;
    this.currencyCode = currencyCode;
    this.centAmount = centAmount;
    this.fractionDigits = fractionDigits;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Currency getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(Currency currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Long getCentAmount() {
    return centAmount;
  }

  public void setCentAmount(Long centAmount) {
    this.centAmount = centAmount;
  }

  /**
   * For the `Money` it equals to the default number of fraction digits used with the currency.
   */
  public Integer getFractionDigits() {
    return fractionDigits;
  }

  public void setFractionDigits(Integer fractionDigits) {
    this.fractionDigits = fractionDigits;
  }

  @Override
  public String toString() {
    return "Money{type='" + type + "', currencyCode='" + currencyCode + "', centAmount='" + centAmount + "', fractionDigits='" + fractionDigits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Money that = (Money) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(currencyCode, that.currencyCode) &&
        Objects.equals(centAmount, that.centAmount) &&
        Objects.equals(fractionDigits, that.fractionDigits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, currencyCode, centAmount, fractionDigits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private Currency currencyCode;

    private Long centAmount;

    /**
     * For the `Money` it equals to the default number of fraction digits used with the currency.
     */
    private Integer fractionDigits;

    public Money build() {
      Money result = new Money();
      result.type = this.type;
      result.currencyCode = this.currencyCode;
      result.centAmount = this.centAmount;
      result.fractionDigits = this.fractionDigits;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder currencyCode(Currency currencyCode) {
      this.currencyCode = currencyCode;
      return this;
    }

    public Builder centAmount(Long centAmount) {
      this.centAmount = centAmount;
      return this;
    }

    /**
     * For the `Money` it equals to the default number of fraction digits used with the currency.
     */
    public Builder fractionDigits(Integer fractionDigits) {
      this.fractionDigits = fractionDigits;
      return this;
    }
  }
}
