package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Currency;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class MoneyAttribute implements com.commercetools.graphql.api.types.Attribute {
  private Long centAmount;

  private Currency currencyCode;

  private String name;

  public MoneyAttribute() {
  }

  public MoneyAttribute(Long centAmount, Currency currencyCode, String name) {
    this.centAmount = centAmount;
    this.currencyCode = currencyCode;
    this.name = name;
  }

  public Long getCentAmount() {
    return centAmount;
  }

  public void setCentAmount(Long centAmount) {
    this.centAmount = centAmount;
  }

  public Currency getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(Currency currencyCode) {
    this.currencyCode = currencyCode;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "MoneyAttribute{centAmount='" + centAmount + "', currencyCode='" + currencyCode + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MoneyAttribute that = (MoneyAttribute) o;
    return Objects.equals(centAmount, that.centAmount) &&
        Objects.equals(currencyCode, that.currencyCode) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(centAmount, currencyCode, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long centAmount;

    private Currency currencyCode;

    private String name;

    public MoneyAttribute build() {
      MoneyAttribute result = new MoneyAttribute();
      result.centAmount = this.centAmount;
      result.currencyCode = this.currencyCode;
      result.name = this.name;
      return result;
    }

    public Builder centAmount(Long centAmount) {
      this.centAmount = centAmount;
      return this;
    }

    public Builder currencyCode(Currency currencyCode) {
      this.currencyCode = currencyCode;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
