package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MoveProductImageToPosition {
  private Integer variantId;

  private String sku;

  private String imageUrl;

  private Integer position;

  private Boolean staged;

  public MoveProductImageToPosition() {
  }

  public MoveProductImageToPosition(Integer variantId, String sku, String imageUrl,
      Integer position, Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.imageUrl = imageUrl;
    this.position = position;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getImageUrl() {
    return imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  public Integer getPosition() {
    return position;
  }

  public void setPosition(Integer position) {
    this.position = position;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "MoveProductImageToPosition{variantId='" + variantId + "', sku='" + sku + "', imageUrl='" + imageUrl + "', position='" + position + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MoveProductImageToPosition that = (MoveProductImageToPosition) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(imageUrl, that.imageUrl) &&
        Objects.equals(position, that.position) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, imageUrl, position, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private String imageUrl;

    private Integer position;

    private Boolean staged;

    public MoveProductImageToPosition build() {
      MoveProductImageToPosition result = new MoveProductImageToPosition();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.imageUrl = this.imageUrl;
      result.position = this.position;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder imageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
      return this;
    }

    public Builder position(Integer position) {
      this.position = position;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
