package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class MyBusinessUnitDraft {
  private String key;

  private String name;

  private String contactEmail;

  private List<AddressInput> addresses;

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultBillingAddress;

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  private Integer defaultShippingAddress;

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  private List<Integer> shippingAddresses = Collections.emptyList();

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  private List<Integer> billingAddresses = Collections.emptyList();

  private CustomFieldsDraft custom;

  private BusinessUnitType unitType;

  private String storeMode;

  private ResourceIdentifierInput parentUnit;

  public MyBusinessUnitDraft() {
  }

  public MyBusinessUnitDraft(String key, String name, String contactEmail,
      List<AddressInput> addresses, Integer defaultBillingAddress, Integer defaultShippingAddress,
      List<Integer> shippingAddresses, List<Integer> billingAddresses, CustomFieldsDraft custom,
      BusinessUnitType unitType, String storeMode, ResourceIdentifierInput parentUnit) {
    this.key = key;
    this.name = name;
    this.contactEmail = contactEmail;
    this.addresses = addresses;
    this.defaultBillingAddress = defaultBillingAddress;
    this.defaultShippingAddress = defaultShippingAddress;
    this.shippingAddresses = shippingAddresses;
    this.billingAddresses = billingAddresses;
    this.custom = custom;
    this.unitType = unitType;
    this.storeMode = storeMode;
    this.parentUnit = parentUnit;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getContactEmail() {
    return contactEmail;
  }

  public void setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }

  public List<AddressInput> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<AddressInput> addresses) {
    this.addresses = addresses;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultBillingAddress() {
    return defaultBillingAddress;
  }

  public void setDefaultBillingAddress(Integer defaultBillingAddress) {
    this.defaultBillingAddress = defaultBillingAddress;
  }

  /**
   * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
   */
  public Integer getDefaultShippingAddress() {
    return defaultShippingAddress;
  }

  public void setDefaultShippingAddress(Integer defaultShippingAddress) {
    this.defaultShippingAddress = defaultShippingAddress;
  }

  /**
   * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
   */
  public List<Integer> getShippingAddresses() {
    return shippingAddresses;
  }

  public void setShippingAddresses(List<Integer> shippingAddresses) {
    this.shippingAddresses = shippingAddresses;
  }

  /**
   * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
   */
  public List<Integer> getBillingAddresses() {
    return billingAddresses;
  }

  public void setBillingAddresses(List<Integer> billingAddresses) {
    this.billingAddresses = billingAddresses;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public BusinessUnitType getUnitType() {
    return unitType;
  }

  public void setUnitType(BusinessUnitType unitType) {
    this.unitType = unitType;
  }

  public String getStoreMode() {
    return storeMode;
  }

  public void setStoreMode(String storeMode) {
    this.storeMode = storeMode;
  }

  public ResourceIdentifierInput getParentUnit() {
    return parentUnit;
  }

  public void setParentUnit(ResourceIdentifierInput parentUnit) {
    this.parentUnit = parentUnit;
  }

  @Override
  public String toString() {
    return "MyBusinessUnitDraft{key='" + key + "', name='" + name + "', contactEmail='" + contactEmail + "', addresses='" + addresses + "', defaultBillingAddress='" + defaultBillingAddress + "', defaultShippingAddress='" + defaultShippingAddress + "', shippingAddresses='" + shippingAddresses + "', billingAddresses='" + billingAddresses + "', custom='" + custom + "', unitType='" + unitType + "', storeMode='" + storeMode + "', parentUnit='" + parentUnit + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyBusinessUnitDraft that = (MyBusinessUnitDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(contactEmail, that.contactEmail) &&
        Objects.equals(addresses, that.addresses) &&
        Objects.equals(defaultBillingAddress, that.defaultBillingAddress) &&
        Objects.equals(defaultShippingAddress, that.defaultShippingAddress) &&
        Objects.equals(shippingAddresses, that.shippingAddresses) &&
        Objects.equals(billingAddresses, that.billingAddresses) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(unitType, that.unitType) &&
        Objects.equals(storeMode, that.storeMode) &&
        Objects.equals(parentUnit, that.parentUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, contactEmail, addresses, defaultBillingAddress, defaultShippingAddress, shippingAddresses, billingAddresses, custom, unitType, storeMode, parentUnit);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private String contactEmail;

    private List<AddressInput> addresses;

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultBillingAddress;

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    private Integer defaultShippingAddress;

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    private List<Integer> shippingAddresses = Collections.emptyList();

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    private List<Integer> billingAddresses = Collections.emptyList();

    private CustomFieldsDraft custom;

    private BusinessUnitType unitType;

    private String storeMode;

    private ResourceIdentifierInput parentUnit;

    public MyBusinessUnitDraft build() {
      MyBusinessUnitDraft result = new MyBusinessUnitDraft();
      result.key = this.key;
      result.name = this.name;
      result.contactEmail = this.contactEmail;
      result.addresses = this.addresses;
      result.defaultBillingAddress = this.defaultBillingAddress;
      result.defaultShippingAddress = this.defaultShippingAddress;
      result.shippingAddresses = this.shippingAddresses;
      result.billingAddresses = this.billingAddresses;
      result.custom = this.custom;
      result.unitType = this.unitType;
      result.storeMode = this.storeMode;
      result.parentUnit = this.parentUnit;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder contactEmail(String contactEmail) {
      this.contactEmail = contactEmail;
      return this;
    }

    public Builder addresses(List<AddressInput> addresses) {
      this.addresses = addresses;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultBillingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultBillingAddress(Integer defaultBillingAddress) {
      this.defaultBillingAddress = defaultBillingAddress;
      return this;
    }

    /**
     * The index of the address in the `addresses` list. The `defaultShippingAddressId` of the customer will be set to the ID of that address.
     */
    public Builder defaultShippingAddress(Integer defaultShippingAddress) {
      this.defaultShippingAddress = defaultShippingAddress;
      return this;
    }

    /**
     * The indices of the shipping addresses in the `addresses` list. The `shippingAddressIds` of the `Customer` will be set to the IDs of that addresses.
     */
    public Builder shippingAddresses(List<Integer> shippingAddresses) {
      this.shippingAddresses = shippingAddresses;
      return this;
    }

    /**
     * The indices of the billing addresses in the `addresses` list. The `billingAddressIds` of the customer will be set to the IDs of that addresses.
     */
    public Builder billingAddresses(List<Integer> billingAddresses) {
      this.billingAddresses = billingAddresses;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder unitType(BusinessUnitType unitType) {
      this.unitType = unitType;
      return this;
    }

    public Builder storeMode(String storeMode) {
      this.storeMode = storeMode;
      return this;
    }

    public Builder parentUnit(ResourceIdentifierInput parentUnit) {
      this.parentUnit = parentUnit;
      return this;
    }
  }
}
