package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class MyBusinessUnitUpdateAction {
  private AddMyBusinessUnitAddress addAddress;

  private AddMyBusinessUnitBillingAddressId addBillingAddressId;

  private AddMyBusinessUnitShippingAddressId addShippingAddressId;

  private ChangeMyBusinessUnitAddress changeAddress;

  private ChangeMyBusinessUnitAssociate changeAssociate;

  private ChangeMyBusinessUnitName changeName;

  private ChangeMyBusinessUnitParentUnit changeParentUnit;

  private RemoveMyBusinessUnitAddress removeAddress;

  private RemoveMyBusinessUnitAssociate removeAssociate;

  private RemoveMyBusinessUnitBillingAddressId removeBillingAddressId;

  private RemoveMyBusinessUnitShippingAddressId removeShippingAddressId;

  private SetMyBusinessUnitAddressCustomField setAddressCustomField;

  private SetMyBusinessUnitAddressCustomType setAddressCustomType;

  private SetMyBusinessUnitContactEmail setContactEmail;

  private SetMyBusinessUnitCustomField setCustomField;

  private SetMyBusinessUnitCustomType setCustomType;

  private SetMyBusinessUnitDefaultBillingAddress setDefaultBillingAddress;

  private SetMyBusinessUnitDefaultShippingAddress setDefaultShippingAddress;

  public MyBusinessUnitUpdateAction() {
  }

  public MyBusinessUnitUpdateAction(AddMyBusinessUnitAddress addAddress,
      AddMyBusinessUnitBillingAddressId addBillingAddressId,
      AddMyBusinessUnitShippingAddressId addShippingAddressId,
      ChangeMyBusinessUnitAddress changeAddress, ChangeMyBusinessUnitAssociate changeAssociate,
      ChangeMyBusinessUnitName changeName, ChangeMyBusinessUnitParentUnit changeParentUnit,
      RemoveMyBusinessUnitAddress removeAddress, RemoveMyBusinessUnitAssociate removeAssociate,
      RemoveMyBusinessUnitBillingAddressId removeBillingAddressId,
      RemoveMyBusinessUnitShippingAddressId removeShippingAddressId,
      SetMyBusinessUnitAddressCustomField setAddressCustomField,
      SetMyBusinessUnitAddressCustomType setAddressCustomType,
      SetMyBusinessUnitContactEmail setContactEmail, SetMyBusinessUnitCustomField setCustomField,
      SetMyBusinessUnitCustomType setCustomType,
      SetMyBusinessUnitDefaultBillingAddress setDefaultBillingAddress,
      SetMyBusinessUnitDefaultShippingAddress setDefaultShippingAddress) {
    this.addAddress = addAddress;
    this.addBillingAddressId = addBillingAddressId;
    this.addShippingAddressId = addShippingAddressId;
    this.changeAddress = changeAddress;
    this.changeAssociate = changeAssociate;
    this.changeName = changeName;
    this.changeParentUnit = changeParentUnit;
    this.removeAddress = removeAddress;
    this.removeAssociate = removeAssociate;
    this.removeBillingAddressId = removeBillingAddressId;
    this.removeShippingAddressId = removeShippingAddressId;
    this.setAddressCustomField = setAddressCustomField;
    this.setAddressCustomType = setAddressCustomType;
    this.setContactEmail = setContactEmail;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDefaultBillingAddress = setDefaultBillingAddress;
    this.setDefaultShippingAddress = setDefaultShippingAddress;
  }

  public AddMyBusinessUnitAddress getAddAddress() {
    return addAddress;
  }

  public void setAddAddress(AddMyBusinessUnitAddress addAddress) {
    this.addAddress = addAddress;
  }

  public AddMyBusinessUnitBillingAddressId getAddBillingAddressId() {
    return addBillingAddressId;
  }

  public void setAddBillingAddressId(AddMyBusinessUnitBillingAddressId addBillingAddressId) {
    this.addBillingAddressId = addBillingAddressId;
  }

  public AddMyBusinessUnitShippingAddressId getAddShippingAddressId() {
    return addShippingAddressId;
  }

  public void setAddShippingAddressId(AddMyBusinessUnitShippingAddressId addShippingAddressId) {
    this.addShippingAddressId = addShippingAddressId;
  }

  public ChangeMyBusinessUnitAddress getChangeAddress() {
    return changeAddress;
  }

  public void setChangeAddress(ChangeMyBusinessUnitAddress changeAddress) {
    this.changeAddress = changeAddress;
  }

  public ChangeMyBusinessUnitAssociate getChangeAssociate() {
    return changeAssociate;
  }

  public void setChangeAssociate(ChangeMyBusinessUnitAssociate changeAssociate) {
    this.changeAssociate = changeAssociate;
  }

  public ChangeMyBusinessUnitName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeMyBusinessUnitName changeName) {
    this.changeName = changeName;
  }

  public ChangeMyBusinessUnitParentUnit getChangeParentUnit() {
    return changeParentUnit;
  }

  public void setChangeParentUnit(ChangeMyBusinessUnitParentUnit changeParentUnit) {
    this.changeParentUnit = changeParentUnit;
  }

  public RemoveMyBusinessUnitAddress getRemoveAddress() {
    return removeAddress;
  }

  public void setRemoveAddress(RemoveMyBusinessUnitAddress removeAddress) {
    this.removeAddress = removeAddress;
  }

  public RemoveMyBusinessUnitAssociate getRemoveAssociate() {
    return removeAssociate;
  }

  public void setRemoveAssociate(RemoveMyBusinessUnitAssociate removeAssociate) {
    this.removeAssociate = removeAssociate;
  }

  public RemoveMyBusinessUnitBillingAddressId getRemoveBillingAddressId() {
    return removeBillingAddressId;
  }

  public void setRemoveBillingAddressId(
      RemoveMyBusinessUnitBillingAddressId removeBillingAddressId) {
    this.removeBillingAddressId = removeBillingAddressId;
  }

  public RemoveMyBusinessUnitShippingAddressId getRemoveShippingAddressId() {
    return removeShippingAddressId;
  }

  public void setRemoveShippingAddressId(
      RemoveMyBusinessUnitShippingAddressId removeShippingAddressId) {
    this.removeShippingAddressId = removeShippingAddressId;
  }

  public SetMyBusinessUnitAddressCustomField getSetAddressCustomField() {
    return setAddressCustomField;
  }

  public void setSetAddressCustomField(SetMyBusinessUnitAddressCustomField setAddressCustomField) {
    this.setAddressCustomField = setAddressCustomField;
  }

  public SetMyBusinessUnitAddressCustomType getSetAddressCustomType() {
    return setAddressCustomType;
  }

  public void setSetAddressCustomType(SetMyBusinessUnitAddressCustomType setAddressCustomType) {
    this.setAddressCustomType = setAddressCustomType;
  }

  public SetMyBusinessUnitContactEmail getSetContactEmail() {
    return setContactEmail;
  }

  public void setSetContactEmail(SetMyBusinessUnitContactEmail setContactEmail) {
    this.setContactEmail = setContactEmail;
  }

  public SetMyBusinessUnitCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetMyBusinessUnitCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetMyBusinessUnitCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetMyBusinessUnitCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetMyBusinessUnitDefaultBillingAddress getSetDefaultBillingAddress() {
    return setDefaultBillingAddress;
  }

  public void setSetDefaultBillingAddress(
      SetMyBusinessUnitDefaultBillingAddress setDefaultBillingAddress) {
    this.setDefaultBillingAddress = setDefaultBillingAddress;
  }

  public SetMyBusinessUnitDefaultShippingAddress getSetDefaultShippingAddress() {
    return setDefaultShippingAddress;
  }

  public void setSetDefaultShippingAddress(
      SetMyBusinessUnitDefaultShippingAddress setDefaultShippingAddress) {
    this.setDefaultShippingAddress = setDefaultShippingAddress;
  }

  @Override
  public String toString() {
    return "MyBusinessUnitUpdateAction{addAddress='" + addAddress + "', addBillingAddressId='" + addBillingAddressId + "', addShippingAddressId='" + addShippingAddressId + "', changeAddress='" + changeAddress + "', changeAssociate='" + changeAssociate + "', changeName='" + changeName + "', changeParentUnit='" + changeParentUnit + "', removeAddress='" + removeAddress + "', removeAssociate='" + removeAssociate + "', removeBillingAddressId='" + removeBillingAddressId + "', removeShippingAddressId='" + removeShippingAddressId + "', setAddressCustomField='" + setAddressCustomField + "', setAddressCustomType='" + setAddressCustomType + "', setContactEmail='" + setContactEmail + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDefaultBillingAddress='" + setDefaultBillingAddress + "', setDefaultShippingAddress='" + setDefaultShippingAddress + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyBusinessUnitUpdateAction that = (MyBusinessUnitUpdateAction) o;
    return Objects.equals(addAddress, that.addAddress) &&
        Objects.equals(addBillingAddressId, that.addBillingAddressId) &&
        Objects.equals(addShippingAddressId, that.addShippingAddressId) &&
        Objects.equals(changeAddress, that.changeAddress) &&
        Objects.equals(changeAssociate, that.changeAssociate) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeParentUnit, that.changeParentUnit) &&
        Objects.equals(removeAddress, that.removeAddress) &&
        Objects.equals(removeAssociate, that.removeAssociate) &&
        Objects.equals(removeBillingAddressId, that.removeBillingAddressId) &&
        Objects.equals(removeShippingAddressId, that.removeShippingAddressId) &&
        Objects.equals(setAddressCustomField, that.setAddressCustomField) &&
        Objects.equals(setAddressCustomType, that.setAddressCustomType) &&
        Objects.equals(setContactEmail, that.setContactEmail) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDefaultBillingAddress, that.setDefaultBillingAddress) &&
        Objects.equals(setDefaultShippingAddress, that.setDefaultShippingAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addAddress, addBillingAddressId, addShippingAddressId, changeAddress, changeAssociate, changeName, changeParentUnit, removeAddress, removeAssociate, removeBillingAddressId, removeShippingAddressId, setAddressCustomField, setAddressCustomType, setContactEmail, setCustomField, setCustomType, setDefaultBillingAddress, setDefaultShippingAddress);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddMyBusinessUnitAddress addAddress;

    private AddMyBusinessUnitBillingAddressId addBillingAddressId;

    private AddMyBusinessUnitShippingAddressId addShippingAddressId;

    private ChangeMyBusinessUnitAddress changeAddress;

    private ChangeMyBusinessUnitAssociate changeAssociate;

    private ChangeMyBusinessUnitName changeName;

    private ChangeMyBusinessUnitParentUnit changeParentUnit;

    private RemoveMyBusinessUnitAddress removeAddress;

    private RemoveMyBusinessUnitAssociate removeAssociate;

    private RemoveMyBusinessUnitBillingAddressId removeBillingAddressId;

    private RemoveMyBusinessUnitShippingAddressId removeShippingAddressId;

    private SetMyBusinessUnitAddressCustomField setAddressCustomField;

    private SetMyBusinessUnitAddressCustomType setAddressCustomType;

    private SetMyBusinessUnitContactEmail setContactEmail;

    private SetMyBusinessUnitCustomField setCustomField;

    private SetMyBusinessUnitCustomType setCustomType;

    private SetMyBusinessUnitDefaultBillingAddress setDefaultBillingAddress;

    private SetMyBusinessUnitDefaultShippingAddress setDefaultShippingAddress;

    public MyBusinessUnitUpdateAction build() {
      MyBusinessUnitUpdateAction result = new MyBusinessUnitUpdateAction();
      result.addAddress = this.addAddress;
      result.addBillingAddressId = this.addBillingAddressId;
      result.addShippingAddressId = this.addShippingAddressId;
      result.changeAddress = this.changeAddress;
      result.changeAssociate = this.changeAssociate;
      result.changeName = this.changeName;
      result.changeParentUnit = this.changeParentUnit;
      result.removeAddress = this.removeAddress;
      result.removeAssociate = this.removeAssociate;
      result.removeBillingAddressId = this.removeBillingAddressId;
      result.removeShippingAddressId = this.removeShippingAddressId;
      result.setAddressCustomField = this.setAddressCustomField;
      result.setAddressCustomType = this.setAddressCustomType;
      result.setContactEmail = this.setContactEmail;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDefaultBillingAddress = this.setDefaultBillingAddress;
      result.setDefaultShippingAddress = this.setDefaultShippingAddress;
      return result;
    }

    public Builder addAddress(AddMyBusinessUnitAddress addAddress) {
      this.addAddress = addAddress;
      return this;
    }

    public Builder addBillingAddressId(AddMyBusinessUnitBillingAddressId addBillingAddressId) {
      this.addBillingAddressId = addBillingAddressId;
      return this;
    }

    public Builder addShippingAddressId(AddMyBusinessUnitShippingAddressId addShippingAddressId) {
      this.addShippingAddressId = addShippingAddressId;
      return this;
    }

    public Builder changeAddress(ChangeMyBusinessUnitAddress changeAddress) {
      this.changeAddress = changeAddress;
      return this;
    }

    public Builder changeAssociate(ChangeMyBusinessUnitAssociate changeAssociate) {
      this.changeAssociate = changeAssociate;
      return this;
    }

    public Builder changeName(ChangeMyBusinessUnitName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeParentUnit(ChangeMyBusinessUnitParentUnit changeParentUnit) {
      this.changeParentUnit = changeParentUnit;
      return this;
    }

    public Builder removeAddress(RemoveMyBusinessUnitAddress removeAddress) {
      this.removeAddress = removeAddress;
      return this;
    }

    public Builder removeAssociate(RemoveMyBusinessUnitAssociate removeAssociate) {
      this.removeAssociate = removeAssociate;
      return this;
    }

    public Builder removeBillingAddressId(
        RemoveMyBusinessUnitBillingAddressId removeBillingAddressId) {
      this.removeBillingAddressId = removeBillingAddressId;
      return this;
    }

    public Builder removeShippingAddressId(
        RemoveMyBusinessUnitShippingAddressId removeShippingAddressId) {
      this.removeShippingAddressId = removeShippingAddressId;
      return this;
    }

    public Builder setAddressCustomField(
        SetMyBusinessUnitAddressCustomField setAddressCustomField) {
      this.setAddressCustomField = setAddressCustomField;
      return this;
    }

    public Builder setAddressCustomType(SetMyBusinessUnitAddressCustomType setAddressCustomType) {
      this.setAddressCustomType = setAddressCustomType;
      return this;
    }

    public Builder setContactEmail(SetMyBusinessUnitContactEmail setContactEmail) {
      this.setContactEmail = setContactEmail;
      return this;
    }

    public Builder setCustomField(SetMyBusinessUnitCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetMyBusinessUnitCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDefaultBillingAddress(
        SetMyBusinessUnitDefaultBillingAddress setDefaultBillingAddress) {
      this.setDefaultBillingAddress = setDefaultBillingAddress;
      return this;
    }

    public Builder setDefaultShippingAddress(
        SetMyBusinessUnitDefaultShippingAddress setDefaultShippingAddress) {
      this.setDefaultShippingAddress = setDefaultShippingAddress;
      return this;
    }
  }
}
