package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

public class MyCartDraft {
  private Currency currency;

  private String country;

  private InventoryMode inventoryMode = InventoryMode.None;

  private CustomFieldsDraft custom;

  private String customerEmail;

  private AddressInput shippingAddress;

  private AddressInput billingAddress;

  private ResourceIdentifierInput shippingMethod;

  private TaxMode taxMode = TaxMode.Platform;

  private String locale;

  private Integer deleteDaysAfterLastModification;

  private List<AddressInput> itemShippingAddresses = Collections.emptyList();

  private List<String> discountCodes = Collections.emptyList();

  private ResourceIdentifierInput store;

  private ResourceIdentifierInput businessUnit;

  private ShippingMode shippingMode = ShippingMode.Single;

  private List<CustomShippingDraft> customShipping = Collections.emptyList();

  private List<ShippingDraft> shipping = Collections.emptyList();

  private List<MyLineItemDraft> lineItems = Collections.emptyList();

  public MyCartDraft() {
  }

  public MyCartDraft(Currency currency, String country, InventoryMode inventoryMode,
      CustomFieldsDraft custom, String customerEmail, AddressInput shippingAddress,
      AddressInput billingAddress, ResourceIdentifierInput shippingMethod, TaxMode taxMode,
      String locale, Integer deleteDaysAfterLastModification,
      List<AddressInput> itemShippingAddresses, List<String> discountCodes,
      ResourceIdentifierInput store, ResourceIdentifierInput businessUnit,
      ShippingMode shippingMode, List<CustomShippingDraft> customShipping,
      List<ShippingDraft> shipping, List<MyLineItemDraft> lineItems) {
    this.currency = currency;
    this.country = country;
    this.inventoryMode = inventoryMode;
    this.custom = custom;
    this.customerEmail = customerEmail;
    this.shippingAddress = shippingAddress;
    this.billingAddress = billingAddress;
    this.shippingMethod = shippingMethod;
    this.taxMode = taxMode;
    this.locale = locale;
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
    this.itemShippingAddresses = itemShippingAddresses;
    this.discountCodes = discountCodes;
    this.store = store;
    this.businessUnit = businessUnit;
    this.shippingMode = shippingMode;
    this.customShipping = customShipping;
    this.shipping = shipping;
    this.lineItems = lineItems;
  }

  public Currency getCurrency() {
    return currency;
  }

  public void setCurrency(Currency currency) {
    this.currency = currency;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getCustomerEmail() {
    return customerEmail;
  }

  public void setCustomerEmail(String customerEmail) {
    this.customerEmail = customerEmail;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public AddressInput getBillingAddress() {
    return billingAddress;
  }

  public void setBillingAddress(AddressInput billingAddress) {
    this.billingAddress = billingAddress;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public List<AddressInput> getItemShippingAddresses() {
    return itemShippingAddresses;
  }

  public void setItemShippingAddresses(List<AddressInput> itemShippingAddresses) {
    this.itemShippingAddresses = itemShippingAddresses;
  }

  public List<String> getDiscountCodes() {
    return discountCodes;
  }

  public void setDiscountCodes(List<String> discountCodes) {
    this.discountCodes = discountCodes;
  }

  public ResourceIdentifierInput getStore() {
    return store;
  }

  public void setStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  public ResourceIdentifierInput getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  public ShippingMode getShippingMode() {
    return shippingMode;
  }

  public void setShippingMode(ShippingMode shippingMode) {
    this.shippingMode = shippingMode;
  }

  public List<CustomShippingDraft> getCustomShipping() {
    return customShipping;
  }

  public void setCustomShipping(List<CustomShippingDraft> customShipping) {
    this.customShipping = customShipping;
  }

  public List<ShippingDraft> getShipping() {
    return shipping;
  }

  public void setShipping(List<ShippingDraft> shipping) {
    this.shipping = shipping;
  }

  public List<MyLineItemDraft> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<MyLineItemDraft> lineItems) {
    this.lineItems = lineItems;
  }

  @Override
  public String toString() {
    return "MyCartDraft{currency='" + currency + "', country='" + country + "', inventoryMode='" + inventoryMode + "', custom='" + custom + "', customerEmail='" + customerEmail + "', shippingAddress='" + shippingAddress + "', billingAddress='" + billingAddress + "', shippingMethod='" + shippingMethod + "', taxMode='" + taxMode + "', locale='" + locale + "', deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "', itemShippingAddresses='" + itemShippingAddresses + "', discountCodes='" + discountCodes + "', store='" + store + "', businessUnit='" + businessUnit + "', shippingMode='" + shippingMode + "', customShipping='" + customShipping + "', shipping='" + shipping + "', lineItems='" + lineItems + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyCartDraft that = (MyCartDraft) o;
    return Objects.equals(currency, that.currency) &&
        Objects.equals(country, that.country) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(customerEmail, that.customerEmail) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(billingAddress, that.billingAddress) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(taxMode, that.taxMode) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification) &&
        Objects.equals(itemShippingAddresses, that.itemShippingAddresses) &&
        Objects.equals(discountCodes, that.discountCodes) &&
        Objects.equals(store, that.store) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(shippingMode, that.shippingMode) &&
        Objects.equals(customShipping, that.customShipping) &&
        Objects.equals(shipping, that.shipping) &&
        Objects.equals(lineItems, that.lineItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, country, inventoryMode, custom, customerEmail, shippingAddress, billingAddress, shippingMethod, taxMode, locale, deleteDaysAfterLastModification, itemShippingAddresses, discountCodes, store, businessUnit, shippingMode, customShipping, shipping, lineItems);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Currency currency;

    private String country;

    private InventoryMode inventoryMode = InventoryMode.None;

    private CustomFieldsDraft custom;

    private String customerEmail;

    private AddressInput shippingAddress;

    private AddressInput billingAddress;

    private ResourceIdentifierInput shippingMethod;

    private TaxMode taxMode = TaxMode.Platform;

    private String locale;

    private Integer deleteDaysAfterLastModification;

    private List<AddressInput> itemShippingAddresses = Collections.emptyList();

    private List<String> discountCodes = Collections.emptyList();

    private ResourceIdentifierInput store;

    private ResourceIdentifierInput businessUnit;

    private ShippingMode shippingMode = ShippingMode.Single;

    private List<CustomShippingDraft> customShipping = Collections.emptyList();

    private List<ShippingDraft> shipping = Collections.emptyList();

    private List<MyLineItemDraft> lineItems = Collections.emptyList();

    public MyCartDraft build() {
      MyCartDraft result = new MyCartDraft();
      result.currency = this.currency;
      result.country = this.country;
      result.inventoryMode = this.inventoryMode;
      result.custom = this.custom;
      result.customerEmail = this.customerEmail;
      result.shippingAddress = this.shippingAddress;
      result.billingAddress = this.billingAddress;
      result.shippingMethod = this.shippingMethod;
      result.taxMode = this.taxMode;
      result.locale = this.locale;
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      result.itemShippingAddresses = this.itemShippingAddresses;
      result.discountCodes = this.discountCodes;
      result.store = this.store;
      result.businessUnit = this.businessUnit;
      result.shippingMode = this.shippingMode;
      result.customShipping = this.customShipping;
      result.shipping = this.shipping;
      result.lineItems = this.lineItems;
      return result;
    }

    public Builder currency(Currency currency) {
      this.currency = currency;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder customerEmail(String customerEmail) {
      this.customerEmail = customerEmail;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder billingAddress(AddressInput billingAddress) {
      this.billingAddress = billingAddress;
      return this;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }

    public Builder itemShippingAddresses(List<AddressInput> itemShippingAddresses) {
      this.itemShippingAddresses = itemShippingAddresses;
      return this;
    }

    public Builder discountCodes(List<String> discountCodes) {
      this.discountCodes = discountCodes;
      return this;
    }

    public Builder store(ResourceIdentifierInput store) {
      this.store = store;
      return this;
    }

    public Builder businessUnit(ResourceIdentifierInput businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder shippingMode(ShippingMode shippingMode) {
      this.shippingMode = shippingMode;
      return this;
    }

    public Builder customShipping(List<CustomShippingDraft> customShipping) {
      this.customShipping = customShipping;
      return this;
    }

    public Builder shipping(List<ShippingDraft> shipping) {
      this.shipping = shipping;
      return this;
    }

    public Builder lineItems(List<MyLineItemDraft> lineItems) {
      this.lineItems = lineItems;
      return this;
    }
  }
}
