package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyCustomerUpdateAction {
  private AddCustomerAddress addAddress;

  private AddCustomerBillingAddressId addBillingAddressId;

  private AddCustomerShippingAddressId addShippingAddressId;

  private ChangeCustomerAddress changeAddress;

  private ChangeCustomerEmail changeEmail;

  private RemoveCustomerAddress removeAddress;

  private RemoveCustomerBillingAddressId removeBillingAddressId;

  private RemoveCustomerShippingAddressId removeShippingAddressId;

  private SetCustomerCompanyName setCompanyName;

  private SetCustomerAddressCustomField setAddressCustomField;

  private SetCustomerAddressCustomType setAddressCustomType;

  private SetCustomerCustomField setCustomField;

  private SetCustomerCustomType setCustomType;

  private SetCustomerLocale setLocale;

  private SetCustomerDateOfBirth setDateOfBirth;

  private SetCustomerDefaultBillingAddress setDefaultBillingAddress;

  private SetCustomerDefaultShippingAddress setDefaultShippingAddress;

  private SetCustomerFirstName setFirstName;

  private SetCustomerLastName setLastName;

  private SetCustomerMiddleName setMiddleName;

  private SetCustomerSalutation setSalutation;

  private SetCustomerTitle setTitle;

  private SetCustomerVatId setVatId;

  public MyCustomerUpdateAction() {
  }

  public MyCustomerUpdateAction(AddCustomerAddress addAddress,
      AddCustomerBillingAddressId addBillingAddressId,
      AddCustomerShippingAddressId addShippingAddressId, ChangeCustomerAddress changeAddress,
      ChangeCustomerEmail changeEmail, RemoveCustomerAddress removeAddress,
      RemoveCustomerBillingAddressId removeBillingAddressId,
      RemoveCustomerShippingAddressId removeShippingAddressId,
      SetCustomerCompanyName setCompanyName, SetCustomerAddressCustomField setAddressCustomField,
      SetCustomerAddressCustomType setAddressCustomType, SetCustomerCustomField setCustomField,
      SetCustomerCustomType setCustomType, SetCustomerLocale setLocale,
      SetCustomerDateOfBirth setDateOfBirth,
      SetCustomerDefaultBillingAddress setDefaultBillingAddress,
      SetCustomerDefaultShippingAddress setDefaultShippingAddress,
      SetCustomerFirstName setFirstName, SetCustomerLastName setLastName,
      SetCustomerMiddleName setMiddleName, SetCustomerSalutation setSalutation,
      SetCustomerTitle setTitle, SetCustomerVatId setVatId) {
    this.addAddress = addAddress;
    this.addBillingAddressId = addBillingAddressId;
    this.addShippingAddressId = addShippingAddressId;
    this.changeAddress = changeAddress;
    this.changeEmail = changeEmail;
    this.removeAddress = removeAddress;
    this.removeBillingAddressId = removeBillingAddressId;
    this.removeShippingAddressId = removeShippingAddressId;
    this.setCompanyName = setCompanyName;
    this.setAddressCustomField = setAddressCustomField;
    this.setAddressCustomType = setAddressCustomType;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setLocale = setLocale;
    this.setDateOfBirth = setDateOfBirth;
    this.setDefaultBillingAddress = setDefaultBillingAddress;
    this.setDefaultShippingAddress = setDefaultShippingAddress;
    this.setFirstName = setFirstName;
    this.setLastName = setLastName;
    this.setMiddleName = setMiddleName;
    this.setSalutation = setSalutation;
    this.setTitle = setTitle;
    this.setVatId = setVatId;
  }

  public AddCustomerAddress getAddAddress() {
    return addAddress;
  }

  public void setAddAddress(AddCustomerAddress addAddress) {
    this.addAddress = addAddress;
  }

  public AddCustomerBillingAddressId getAddBillingAddressId() {
    return addBillingAddressId;
  }

  public void setAddBillingAddressId(AddCustomerBillingAddressId addBillingAddressId) {
    this.addBillingAddressId = addBillingAddressId;
  }

  public AddCustomerShippingAddressId getAddShippingAddressId() {
    return addShippingAddressId;
  }

  public void setAddShippingAddressId(AddCustomerShippingAddressId addShippingAddressId) {
    this.addShippingAddressId = addShippingAddressId;
  }

  public ChangeCustomerAddress getChangeAddress() {
    return changeAddress;
  }

  public void setChangeAddress(ChangeCustomerAddress changeAddress) {
    this.changeAddress = changeAddress;
  }

  public ChangeCustomerEmail getChangeEmail() {
    return changeEmail;
  }

  public void setChangeEmail(ChangeCustomerEmail changeEmail) {
    this.changeEmail = changeEmail;
  }

  public RemoveCustomerAddress getRemoveAddress() {
    return removeAddress;
  }

  public void setRemoveAddress(RemoveCustomerAddress removeAddress) {
    this.removeAddress = removeAddress;
  }

  public RemoveCustomerBillingAddressId getRemoveBillingAddressId() {
    return removeBillingAddressId;
  }

  public void setRemoveBillingAddressId(RemoveCustomerBillingAddressId removeBillingAddressId) {
    this.removeBillingAddressId = removeBillingAddressId;
  }

  public RemoveCustomerShippingAddressId getRemoveShippingAddressId() {
    return removeShippingAddressId;
  }

  public void setRemoveShippingAddressId(RemoveCustomerShippingAddressId removeShippingAddressId) {
    this.removeShippingAddressId = removeShippingAddressId;
  }

  public SetCustomerCompanyName getSetCompanyName() {
    return setCompanyName;
  }

  public void setSetCompanyName(SetCustomerCompanyName setCompanyName) {
    this.setCompanyName = setCompanyName;
  }

  public SetCustomerAddressCustomField getSetAddressCustomField() {
    return setAddressCustomField;
  }

  public void setSetAddressCustomField(SetCustomerAddressCustomField setAddressCustomField) {
    this.setAddressCustomField = setAddressCustomField;
  }

  public SetCustomerAddressCustomType getSetAddressCustomType() {
    return setAddressCustomType;
  }

  public void setSetAddressCustomType(SetCustomerAddressCustomType setAddressCustomType) {
    this.setAddressCustomType = setAddressCustomType;
  }

  public SetCustomerCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetCustomerCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetCustomerCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetCustomerCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetCustomerLocale getSetLocale() {
    return setLocale;
  }

  public void setSetLocale(SetCustomerLocale setLocale) {
    this.setLocale = setLocale;
  }

  public SetCustomerDateOfBirth getSetDateOfBirth() {
    return setDateOfBirth;
  }

  public void setSetDateOfBirth(SetCustomerDateOfBirth setDateOfBirth) {
    this.setDateOfBirth = setDateOfBirth;
  }

  public SetCustomerDefaultBillingAddress getSetDefaultBillingAddress() {
    return setDefaultBillingAddress;
  }

  public void setSetDefaultBillingAddress(
      SetCustomerDefaultBillingAddress setDefaultBillingAddress) {
    this.setDefaultBillingAddress = setDefaultBillingAddress;
  }

  public SetCustomerDefaultShippingAddress getSetDefaultShippingAddress() {
    return setDefaultShippingAddress;
  }

  public void setSetDefaultShippingAddress(
      SetCustomerDefaultShippingAddress setDefaultShippingAddress) {
    this.setDefaultShippingAddress = setDefaultShippingAddress;
  }

  public SetCustomerFirstName getSetFirstName() {
    return setFirstName;
  }

  public void setSetFirstName(SetCustomerFirstName setFirstName) {
    this.setFirstName = setFirstName;
  }

  public SetCustomerLastName getSetLastName() {
    return setLastName;
  }

  public void setSetLastName(SetCustomerLastName setLastName) {
    this.setLastName = setLastName;
  }

  public SetCustomerMiddleName getSetMiddleName() {
    return setMiddleName;
  }

  public void setSetMiddleName(SetCustomerMiddleName setMiddleName) {
    this.setMiddleName = setMiddleName;
  }

  public SetCustomerSalutation getSetSalutation() {
    return setSalutation;
  }

  public void setSetSalutation(SetCustomerSalutation setSalutation) {
    this.setSalutation = setSalutation;
  }

  public SetCustomerTitle getSetTitle() {
    return setTitle;
  }

  public void setSetTitle(SetCustomerTitle setTitle) {
    this.setTitle = setTitle;
  }

  public SetCustomerVatId getSetVatId() {
    return setVatId;
  }

  public void setSetVatId(SetCustomerVatId setVatId) {
    this.setVatId = setVatId;
  }

  @Override
  public String toString() {
    return "MyCustomerUpdateAction{addAddress='" + addAddress + "', addBillingAddressId='" + addBillingAddressId + "', addShippingAddressId='" + addShippingAddressId + "', changeAddress='" + changeAddress + "', changeEmail='" + changeEmail + "', removeAddress='" + removeAddress + "', removeBillingAddressId='" + removeBillingAddressId + "', removeShippingAddressId='" + removeShippingAddressId + "', setCompanyName='" + setCompanyName + "', setAddressCustomField='" + setAddressCustomField + "', setAddressCustomType='" + setAddressCustomType + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setLocale='" + setLocale + "', setDateOfBirth='" + setDateOfBirth + "', setDefaultBillingAddress='" + setDefaultBillingAddress + "', setDefaultShippingAddress='" + setDefaultShippingAddress + "', setFirstName='" + setFirstName + "', setLastName='" + setLastName + "', setMiddleName='" + setMiddleName + "', setSalutation='" + setSalutation + "', setTitle='" + setTitle + "', setVatId='" + setVatId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyCustomerUpdateAction that = (MyCustomerUpdateAction) o;
    return Objects.equals(addAddress, that.addAddress) &&
        Objects.equals(addBillingAddressId, that.addBillingAddressId) &&
        Objects.equals(addShippingAddressId, that.addShippingAddressId) &&
        Objects.equals(changeAddress, that.changeAddress) &&
        Objects.equals(changeEmail, that.changeEmail) &&
        Objects.equals(removeAddress, that.removeAddress) &&
        Objects.equals(removeBillingAddressId, that.removeBillingAddressId) &&
        Objects.equals(removeShippingAddressId, that.removeShippingAddressId) &&
        Objects.equals(setCompanyName, that.setCompanyName) &&
        Objects.equals(setAddressCustomField, that.setAddressCustomField) &&
        Objects.equals(setAddressCustomType, that.setAddressCustomType) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setLocale, that.setLocale) &&
        Objects.equals(setDateOfBirth, that.setDateOfBirth) &&
        Objects.equals(setDefaultBillingAddress, that.setDefaultBillingAddress) &&
        Objects.equals(setDefaultShippingAddress, that.setDefaultShippingAddress) &&
        Objects.equals(setFirstName, that.setFirstName) &&
        Objects.equals(setLastName, that.setLastName) &&
        Objects.equals(setMiddleName, that.setMiddleName) &&
        Objects.equals(setSalutation, that.setSalutation) &&
        Objects.equals(setTitle, that.setTitle) &&
        Objects.equals(setVatId, that.setVatId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addAddress, addBillingAddressId, addShippingAddressId, changeAddress, changeEmail, removeAddress, removeBillingAddressId, removeShippingAddressId, setCompanyName, setAddressCustomField, setAddressCustomType, setCustomField, setCustomType, setLocale, setDateOfBirth, setDefaultBillingAddress, setDefaultShippingAddress, setFirstName, setLastName, setMiddleName, setSalutation, setTitle, setVatId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddCustomerAddress addAddress;

    private AddCustomerBillingAddressId addBillingAddressId;

    private AddCustomerShippingAddressId addShippingAddressId;

    private ChangeCustomerAddress changeAddress;

    private ChangeCustomerEmail changeEmail;

    private RemoveCustomerAddress removeAddress;

    private RemoveCustomerBillingAddressId removeBillingAddressId;

    private RemoveCustomerShippingAddressId removeShippingAddressId;

    private SetCustomerCompanyName setCompanyName;

    private SetCustomerAddressCustomField setAddressCustomField;

    private SetCustomerAddressCustomType setAddressCustomType;

    private SetCustomerCustomField setCustomField;

    private SetCustomerCustomType setCustomType;

    private SetCustomerLocale setLocale;

    private SetCustomerDateOfBirth setDateOfBirth;

    private SetCustomerDefaultBillingAddress setDefaultBillingAddress;

    private SetCustomerDefaultShippingAddress setDefaultShippingAddress;

    private SetCustomerFirstName setFirstName;

    private SetCustomerLastName setLastName;

    private SetCustomerMiddleName setMiddleName;

    private SetCustomerSalutation setSalutation;

    private SetCustomerTitle setTitle;

    private SetCustomerVatId setVatId;

    public MyCustomerUpdateAction build() {
      MyCustomerUpdateAction result = new MyCustomerUpdateAction();
      result.addAddress = this.addAddress;
      result.addBillingAddressId = this.addBillingAddressId;
      result.addShippingAddressId = this.addShippingAddressId;
      result.changeAddress = this.changeAddress;
      result.changeEmail = this.changeEmail;
      result.removeAddress = this.removeAddress;
      result.removeBillingAddressId = this.removeBillingAddressId;
      result.removeShippingAddressId = this.removeShippingAddressId;
      result.setCompanyName = this.setCompanyName;
      result.setAddressCustomField = this.setAddressCustomField;
      result.setAddressCustomType = this.setAddressCustomType;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setLocale = this.setLocale;
      result.setDateOfBirth = this.setDateOfBirth;
      result.setDefaultBillingAddress = this.setDefaultBillingAddress;
      result.setDefaultShippingAddress = this.setDefaultShippingAddress;
      result.setFirstName = this.setFirstName;
      result.setLastName = this.setLastName;
      result.setMiddleName = this.setMiddleName;
      result.setSalutation = this.setSalutation;
      result.setTitle = this.setTitle;
      result.setVatId = this.setVatId;
      return result;
    }

    public Builder addAddress(AddCustomerAddress addAddress) {
      this.addAddress = addAddress;
      return this;
    }

    public Builder addBillingAddressId(AddCustomerBillingAddressId addBillingAddressId) {
      this.addBillingAddressId = addBillingAddressId;
      return this;
    }

    public Builder addShippingAddressId(AddCustomerShippingAddressId addShippingAddressId) {
      this.addShippingAddressId = addShippingAddressId;
      return this;
    }

    public Builder changeAddress(ChangeCustomerAddress changeAddress) {
      this.changeAddress = changeAddress;
      return this;
    }

    public Builder changeEmail(ChangeCustomerEmail changeEmail) {
      this.changeEmail = changeEmail;
      return this;
    }

    public Builder removeAddress(RemoveCustomerAddress removeAddress) {
      this.removeAddress = removeAddress;
      return this;
    }

    public Builder removeBillingAddressId(RemoveCustomerBillingAddressId removeBillingAddressId) {
      this.removeBillingAddressId = removeBillingAddressId;
      return this;
    }

    public Builder removeShippingAddressId(
        RemoveCustomerShippingAddressId removeShippingAddressId) {
      this.removeShippingAddressId = removeShippingAddressId;
      return this;
    }

    public Builder setCompanyName(SetCustomerCompanyName setCompanyName) {
      this.setCompanyName = setCompanyName;
      return this;
    }

    public Builder setAddressCustomField(SetCustomerAddressCustomField setAddressCustomField) {
      this.setAddressCustomField = setAddressCustomField;
      return this;
    }

    public Builder setAddressCustomType(SetCustomerAddressCustomType setAddressCustomType) {
      this.setAddressCustomType = setAddressCustomType;
      return this;
    }

    public Builder setCustomField(SetCustomerCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetCustomerCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setLocale(SetCustomerLocale setLocale) {
      this.setLocale = setLocale;
      return this;
    }

    public Builder setDateOfBirth(SetCustomerDateOfBirth setDateOfBirth) {
      this.setDateOfBirth = setDateOfBirth;
      return this;
    }

    public Builder setDefaultBillingAddress(
        SetCustomerDefaultBillingAddress setDefaultBillingAddress) {
      this.setDefaultBillingAddress = setDefaultBillingAddress;
      return this;
    }

    public Builder setDefaultShippingAddress(
        SetCustomerDefaultShippingAddress setDefaultShippingAddress) {
      this.setDefaultShippingAddress = setDefaultShippingAddress;
      return this;
    }

    public Builder setFirstName(SetCustomerFirstName setFirstName) {
      this.setFirstName = setFirstName;
      return this;
    }

    public Builder setLastName(SetCustomerLastName setLastName) {
      this.setLastName = setLastName;
      return this;
    }

    public Builder setMiddleName(SetCustomerMiddleName setMiddleName) {
      this.setMiddleName = setMiddleName;
      return this;
    }

    public Builder setSalutation(SetCustomerSalutation setSalutation) {
      this.setSalutation = setSalutation;
      return this;
    }

    public Builder setTitle(SetCustomerTitle setTitle) {
      this.setTitle = setTitle;
      return this;
    }

    public Builder setVatId(SetCustomerVatId setVatId) {
      this.setVatId = setVatId;
      return this;
    }
  }
}
