package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyPaymentDraft {
  private MoneyInput amountPlanned;

  private PaymentMethodInfoInput paymentMethodInfo;

  private CustomFieldsDraft custom;

  private MyTransactionDraft transaction;

  public MyPaymentDraft() {
  }

  public MyPaymentDraft(MoneyInput amountPlanned, PaymentMethodInfoInput paymentMethodInfo,
      CustomFieldsDraft custom, MyTransactionDraft transaction) {
    this.amountPlanned = amountPlanned;
    this.paymentMethodInfo = paymentMethodInfo;
    this.custom = custom;
    this.transaction = transaction;
  }

  public MoneyInput getAmountPlanned() {
    return amountPlanned;
  }

  public void setAmountPlanned(MoneyInput amountPlanned) {
    this.amountPlanned = amountPlanned;
  }

  public PaymentMethodInfoInput getPaymentMethodInfo() {
    return paymentMethodInfo;
  }

  public void setPaymentMethodInfo(PaymentMethodInfoInput paymentMethodInfo) {
    this.paymentMethodInfo = paymentMethodInfo;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public MyTransactionDraft getTransaction() {
    return transaction;
  }

  public void setTransaction(MyTransactionDraft transaction) {
    this.transaction = transaction;
  }

  @Override
  public String toString() {
    return "MyPaymentDraft{amountPlanned='" + amountPlanned + "', paymentMethodInfo='" + paymentMethodInfo + "', custom='" + custom + "', transaction='" + transaction + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyPaymentDraft that = (MyPaymentDraft) o;
    return Objects.equals(amountPlanned, that.amountPlanned) &&
        Objects.equals(paymentMethodInfo, that.paymentMethodInfo) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(transaction, that.transaction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountPlanned, paymentMethodInfo, custom, transaction);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput amountPlanned;

    private PaymentMethodInfoInput paymentMethodInfo;

    private CustomFieldsDraft custom;

    private MyTransactionDraft transaction;

    public MyPaymentDraft build() {
      MyPaymentDraft result = new MyPaymentDraft();
      result.amountPlanned = this.amountPlanned;
      result.paymentMethodInfo = this.paymentMethodInfo;
      result.custom = this.custom;
      result.transaction = this.transaction;
      return result;
    }

    public Builder amountPlanned(MoneyInput amountPlanned) {
      this.amountPlanned = amountPlanned;
      return this;
    }

    public Builder paymentMethodInfo(PaymentMethodInfoInput paymentMethodInfo) {
      this.paymentMethodInfo = paymentMethodInfo;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder transaction(MyTransactionDraft transaction) {
      this.transaction = transaction;
      return this;
    }
  }
}
