package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyPaymentUpdateAction {
  private AddMyPaymentTransaction addTransaction;

  private ChangePaymentAmountPlanned changeAmountPlanned;

  private SetPaymentCustomField setCustomField;

  private SetPaymentMethodInfoInterface setMethodInfoInterface;

  private SetPaymentMethodInfoMethod setMethodInfoMethod;

  private SetPaymentMethodInfoName setMethodInfoName;

  public MyPaymentUpdateAction() {
  }

  public MyPaymentUpdateAction(AddMyPaymentTransaction addTransaction,
      ChangePaymentAmountPlanned changeAmountPlanned, SetPaymentCustomField setCustomField,
      SetPaymentMethodInfoInterface setMethodInfoInterface,
      SetPaymentMethodInfoMethod setMethodInfoMethod, SetPaymentMethodInfoName setMethodInfoName) {
    this.addTransaction = addTransaction;
    this.changeAmountPlanned = changeAmountPlanned;
    this.setCustomField = setCustomField;
    this.setMethodInfoInterface = setMethodInfoInterface;
    this.setMethodInfoMethod = setMethodInfoMethod;
    this.setMethodInfoName = setMethodInfoName;
  }

  public AddMyPaymentTransaction getAddTransaction() {
    return addTransaction;
  }

  public void setAddTransaction(AddMyPaymentTransaction addTransaction) {
    this.addTransaction = addTransaction;
  }

  public ChangePaymentAmountPlanned getChangeAmountPlanned() {
    return changeAmountPlanned;
  }

  public void setChangeAmountPlanned(ChangePaymentAmountPlanned changeAmountPlanned) {
    this.changeAmountPlanned = changeAmountPlanned;
  }

  public SetPaymentCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetPaymentCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetPaymentMethodInfoInterface getSetMethodInfoInterface() {
    return setMethodInfoInterface;
  }

  public void setSetMethodInfoInterface(SetPaymentMethodInfoInterface setMethodInfoInterface) {
    this.setMethodInfoInterface = setMethodInfoInterface;
  }

  public SetPaymentMethodInfoMethod getSetMethodInfoMethod() {
    return setMethodInfoMethod;
  }

  public void setSetMethodInfoMethod(SetPaymentMethodInfoMethod setMethodInfoMethod) {
    this.setMethodInfoMethod = setMethodInfoMethod;
  }

  public SetPaymentMethodInfoName getSetMethodInfoName() {
    return setMethodInfoName;
  }

  public void setSetMethodInfoName(SetPaymentMethodInfoName setMethodInfoName) {
    this.setMethodInfoName = setMethodInfoName;
  }

  @Override
  public String toString() {
    return "MyPaymentUpdateAction{addTransaction='" + addTransaction + "', changeAmountPlanned='" + changeAmountPlanned + "', setCustomField='" + setCustomField + "', setMethodInfoInterface='" + setMethodInfoInterface + "', setMethodInfoMethod='" + setMethodInfoMethod + "', setMethodInfoName='" + setMethodInfoName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyPaymentUpdateAction that = (MyPaymentUpdateAction) o;
    return Objects.equals(addTransaction, that.addTransaction) &&
        Objects.equals(changeAmountPlanned, that.changeAmountPlanned) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setMethodInfoInterface, that.setMethodInfoInterface) &&
        Objects.equals(setMethodInfoMethod, that.setMethodInfoMethod) &&
        Objects.equals(setMethodInfoName, that.setMethodInfoName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addTransaction, changeAmountPlanned, setCustomField, setMethodInfoInterface, setMethodInfoMethod, setMethodInfoName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddMyPaymentTransaction addTransaction;

    private ChangePaymentAmountPlanned changeAmountPlanned;

    private SetPaymentCustomField setCustomField;

    private SetPaymentMethodInfoInterface setMethodInfoInterface;

    private SetPaymentMethodInfoMethod setMethodInfoMethod;

    private SetPaymentMethodInfoName setMethodInfoName;

    public MyPaymentUpdateAction build() {
      MyPaymentUpdateAction result = new MyPaymentUpdateAction();
      result.addTransaction = this.addTransaction;
      result.changeAmountPlanned = this.changeAmountPlanned;
      result.setCustomField = this.setCustomField;
      result.setMethodInfoInterface = this.setMethodInfoInterface;
      result.setMethodInfoMethod = this.setMethodInfoMethod;
      result.setMethodInfoName = this.setMethodInfoName;
      return result;
    }

    public Builder addTransaction(AddMyPaymentTransaction addTransaction) {
      this.addTransaction = addTransaction;
      return this;
    }

    public Builder changeAmountPlanned(ChangePaymentAmountPlanned changeAmountPlanned) {
      this.changeAmountPlanned = changeAmountPlanned;
      return this;
    }

    public Builder setCustomField(SetPaymentCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setMethodInfoInterface(SetPaymentMethodInfoInterface setMethodInfoInterface) {
      this.setMethodInfoInterface = setMethodInfoInterface;
      return this;
    }

    public Builder setMethodInfoMethod(SetPaymentMethodInfoMethod setMethodInfoMethod) {
      this.setMethodInfoMethod = setMethodInfoMethod;
      return this;
    }

    public Builder setMethodInfoName(SetPaymentMethodInfoName setMethodInfoName) {
      this.setMethodInfoName = setMethodInfoName;
      return this;
    }
  }
}
