package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyQuoteRequestUpdateAction {
  private CancelQuoteRequest cancelQuoteRequest;

  private SetMyQuoteRequestCustomField setCustomField;

  private SetMyQuoteRequestCustomType setCustomType;

  public MyQuoteRequestUpdateAction() {
  }

  public MyQuoteRequestUpdateAction(CancelQuoteRequest cancelQuoteRequest,
      SetMyQuoteRequestCustomField setCustomField, SetMyQuoteRequestCustomType setCustomType) {
    this.cancelQuoteRequest = cancelQuoteRequest;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
  }

  public CancelQuoteRequest getCancelQuoteRequest() {
    return cancelQuoteRequest;
  }

  public void setCancelQuoteRequest(CancelQuoteRequest cancelQuoteRequest) {
    this.cancelQuoteRequest = cancelQuoteRequest;
  }

  public SetMyQuoteRequestCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetMyQuoteRequestCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetMyQuoteRequestCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetMyQuoteRequestCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  @Override
  public String toString() {
    return "MyQuoteRequestUpdateAction{cancelQuoteRequest='" + cancelQuoteRequest + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyQuoteRequestUpdateAction that = (MyQuoteRequestUpdateAction) o;
    return Objects.equals(cancelQuoteRequest, that.cancelQuoteRequest) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cancelQuoteRequest, setCustomField, setCustomType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CancelQuoteRequest cancelQuoteRequest;

    private SetMyQuoteRequestCustomField setCustomField;

    private SetMyQuoteRequestCustomType setCustomType;

    public MyQuoteRequestUpdateAction build() {
      MyQuoteRequestUpdateAction result = new MyQuoteRequestUpdateAction();
      result.cancelQuoteRequest = this.cancelQuoteRequest;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      return result;
    }

    public Builder cancelQuoteRequest(CancelQuoteRequest cancelQuoteRequest) {
      this.cancelQuoteRequest = cancelQuoteRequest;
      return this;
    }

    public Builder setCustomField(SetMyQuoteRequestCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetMyQuoteRequestCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }
  }
}
