package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MyQuoteUpdateAction {
  private ChangeMyQuoteMyQuoteState changeMyQuoteState;

  private RequestQuoteRenegotiation requestQuoteRenegotiation;

  private SetQuoteCustomField setCustomField;

  private SetQuoteCustomType setCustomType;

  public MyQuoteUpdateAction() {
  }

  public MyQuoteUpdateAction(ChangeMyQuoteMyQuoteState changeMyQuoteState,
      RequestQuoteRenegotiation requestQuoteRenegotiation, SetQuoteCustomField setCustomField,
      SetQuoteCustomType setCustomType) {
    this.changeMyQuoteState = changeMyQuoteState;
    this.requestQuoteRenegotiation = requestQuoteRenegotiation;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
  }

  public ChangeMyQuoteMyQuoteState getChangeMyQuoteState() {
    return changeMyQuoteState;
  }

  public void setChangeMyQuoteState(ChangeMyQuoteMyQuoteState changeMyQuoteState) {
    this.changeMyQuoteState = changeMyQuoteState;
  }

  public RequestQuoteRenegotiation getRequestQuoteRenegotiation() {
    return requestQuoteRenegotiation;
  }

  public void setRequestQuoteRenegotiation(RequestQuoteRenegotiation requestQuoteRenegotiation) {
    this.requestQuoteRenegotiation = requestQuoteRenegotiation;
  }

  public SetQuoteCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetQuoteCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetQuoteCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetQuoteCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  @Override
  public String toString() {
    return "MyQuoteUpdateAction{changeMyQuoteState='" + changeMyQuoteState + "', requestQuoteRenegotiation='" + requestQuoteRenegotiation + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyQuoteUpdateAction that = (MyQuoteUpdateAction) o;
    return Objects.equals(changeMyQuoteState, that.changeMyQuoteState) &&
        Objects.equals(requestQuoteRenegotiation, that.requestQuoteRenegotiation) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeMyQuoteState, requestQuoteRenegotiation, setCustomField, setCustomType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeMyQuoteMyQuoteState changeMyQuoteState;

    private RequestQuoteRenegotiation requestQuoteRenegotiation;

    private SetQuoteCustomField setCustomField;

    private SetQuoteCustomType setCustomType;

    public MyQuoteUpdateAction build() {
      MyQuoteUpdateAction result = new MyQuoteUpdateAction();
      result.changeMyQuoteState = this.changeMyQuoteState;
      result.requestQuoteRenegotiation = this.requestQuoteRenegotiation;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      return result;
    }

    public Builder changeMyQuoteState(ChangeMyQuoteMyQuoteState changeMyQuoteState) {
      this.changeMyQuoteState = changeMyQuoteState;
      return this;
    }

    public Builder requestQuoteRenegotiation(RequestQuoteRenegotiation requestQuoteRenegotiation) {
      this.requestQuoteRenegotiation = requestQuoteRenegotiation;
      return this;
    }

    public Builder setCustomField(SetQuoteCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetQuoteCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }
  }
}
