package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MyShoppingListDraft {
  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private List<ShoppingListLineItemDraft> lineItems = Collections.emptyList();

  private List<TextLineItemDraft> textLineItems = Collections.emptyList();

  private CustomFieldsDraft custom;

  private Integer deleteDaysAfterLastModification;

  public MyShoppingListDraft() {
  }

  public MyShoppingListDraft(List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, List<ShoppingListLineItemDraft> lineItems,
      List<TextLineItemDraft> textLineItems, CustomFieldsDraft custom,
      Integer deleteDaysAfterLastModification) {
    this.name = name;
    this.description = description;
    this.lineItems = lineItems;
    this.textLineItems = textLineItems;
    this.custom = custom;
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<ShoppingListLineItemDraft> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<ShoppingListLineItemDraft> lineItems) {
    this.lineItems = lineItems;
  }

  public List<TextLineItemDraft> getTextLineItems() {
    return textLineItems;
  }

  public void setTextLineItems(List<TextLineItemDraft> textLineItems) {
    this.textLineItems = textLineItems;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  @Override
  public String toString() {
    return "MyShoppingListDraft{name='" + name + "', description='" + description + "', lineItems='" + lineItems + "', textLineItems='" + textLineItems + "', custom='" + custom + "', deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MyShoppingListDraft that = (MyShoppingListDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(textLineItems, that.textLineItems) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, lineItems, textLineItems, custom, deleteDaysAfterLastModification);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private List<ShoppingListLineItemDraft> lineItems = Collections.emptyList();

    private List<TextLineItemDraft> textLineItems = Collections.emptyList();

    private CustomFieldsDraft custom;

    private Integer deleteDaysAfterLastModification;

    public MyShoppingListDraft build() {
      MyShoppingListDraft result = new MyShoppingListDraft();
      result.name = this.name;
      result.description = this.description;
      result.lineItems = this.lineItems;
      result.textLineItems = this.textLineItems;
      result.custom = this.custom;
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder lineItems(List<ShoppingListLineItemDraft> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder textLineItems(List<TextLineItemDraft> textLineItems) {
      this.textLineItems = textLineItems;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }
  }
}
