package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * An order can be created from a cart, usually after a checkout process has been completed.
 * [documentation](https://docs.commercetools.com/api/projects/orders)
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Order implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String customerId;

  private Customer customer;

  private String customerEmail;

  private String anonymousId;

  private List<LineItem> lineItems;

  private List<CustomLineItem> customLineItems;

  private Money totalPrice;

  private TaxedPrice taxedPrice;

  private DiscountOnTotalPrice discountOnTotalPrice;

  private Address shippingAddress;

  private Address billingAddress;

  private InventoryMode inventoryMode;

  private TaxMode taxMode;

  private RoundingMode taxRoundingMode;

  private TaxCalculationMode taxCalculationMode;

  private CustomerGroup customerGroup;

  private Reference customerGroupRef;

  private String country;

  private String shippingKey;

  private ShippingInfo shippingInfo;

  private List<DiscountCodeInfo> discountCodes;

  private List<DirectDiscount> directDiscounts;

  private DiscountTypeCombination discountTypeCombination;

  private List<CartDiscount> refusedGifts;

  private List<Reference> refusedGiftsRefs;

  private PaymentInfo paymentInfo;

  private String locale;

  private ShippingRateInput shippingRateInput;

  private CartOrigin origin;

  private KeyReference storeRef;

  private Store store;

  private List<Address> itemShippingAddresses;

  private BusinessUnit businessUnit;

  private KeyReference businessUnitRef;

  private List<Shipping> shipping;

  private TaxedPrice taxedShippingPrice;

  private ShippingMode shippingMode;

  private CustomFieldsType shippingCustomFields;

  private OffsetDateTime completedAt;

  private String orderNumber;

  private OrderState orderState;

  private Reference stateRef;

  private State state;

  private ShipmentState shipmentState;

  private PaymentState paymentState;

  private List<SyncInfo> syncInfo;

  private List<ReturnInfo> returnInfo;

  private String purchaseOrderNumber;

  private Long lastMessageSequenceNumber;

  private Reference cartRef;

  private Cart cart;

  private Reference quoteRef;

  private Quote quote;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Order() {
  }

  public Order(String customerId, Customer customer, String customerEmail, String anonymousId,
      List<LineItem> lineItems, List<CustomLineItem> customLineItems, Money totalPrice,
      TaxedPrice taxedPrice, DiscountOnTotalPrice discountOnTotalPrice, Address shippingAddress,
      Address billingAddress, InventoryMode inventoryMode, TaxMode taxMode,
      RoundingMode taxRoundingMode, TaxCalculationMode taxCalculationMode,
      CustomerGroup customerGroup, Reference customerGroupRef, String country, String shippingKey,
      ShippingInfo shippingInfo, List<DiscountCodeInfo> discountCodes,
      List<DirectDiscount> directDiscounts, DiscountTypeCombination discountTypeCombination,
      List<CartDiscount> refusedGifts, List<Reference> refusedGiftsRefs, PaymentInfo paymentInfo,
      String locale, ShippingRateInput shippingRateInput, CartOrigin origin, KeyReference storeRef,
      Store store, List<Address> itemShippingAddresses, BusinessUnit businessUnit,
      KeyReference businessUnitRef, List<Shipping> shipping, TaxedPrice taxedShippingPrice,
      ShippingMode shippingMode, CustomFieldsType shippingCustomFields, OffsetDateTime completedAt,
      String orderNumber, OrderState orderState, Reference stateRef, State state,
      ShipmentState shipmentState, PaymentState paymentState, List<SyncInfo> syncInfo,
      List<ReturnInfo> returnInfo, String purchaseOrderNumber, Long lastMessageSequenceNumber,
      Reference cartRef, Cart cart, Reference quoteRef, Quote quote, CustomFieldsType custom,
      String id, Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt,
      Initiator createdBy, Initiator lastModifiedBy) {
    this.customerId = customerId;
    this.customer = customer;
    this.customerEmail = customerEmail;
    this.anonymousId = anonymousId;
    this.lineItems = lineItems;
    this.customLineItems = customLineItems;
    this.totalPrice = totalPrice;
    this.taxedPrice = taxedPrice;
    this.discountOnTotalPrice = discountOnTotalPrice;
    this.shippingAddress = shippingAddress;
    this.billingAddress = billingAddress;
    this.inventoryMode = inventoryMode;
    this.taxMode = taxMode;
    this.taxRoundingMode = taxRoundingMode;
    this.taxCalculationMode = taxCalculationMode;
    this.customerGroup = customerGroup;
    this.customerGroupRef = customerGroupRef;
    this.country = country;
    this.shippingKey = shippingKey;
    this.shippingInfo = shippingInfo;
    this.discountCodes = discountCodes;
    this.directDiscounts = directDiscounts;
    this.discountTypeCombination = discountTypeCombination;
    this.refusedGifts = refusedGifts;
    this.refusedGiftsRefs = refusedGiftsRefs;
    this.paymentInfo = paymentInfo;
    this.locale = locale;
    this.shippingRateInput = shippingRateInput;
    this.origin = origin;
    this.storeRef = storeRef;
    this.store = store;
    this.itemShippingAddresses = itemShippingAddresses;
    this.businessUnit = businessUnit;
    this.businessUnitRef = businessUnitRef;
    this.shipping = shipping;
    this.taxedShippingPrice = taxedShippingPrice;
    this.shippingMode = shippingMode;
    this.shippingCustomFields = shippingCustomFields;
    this.completedAt = completedAt;
    this.orderNumber = orderNumber;
    this.orderState = orderState;
    this.stateRef = stateRef;
    this.state = state;
    this.shipmentState = shipmentState;
    this.paymentState = paymentState;
    this.syncInfo = syncInfo;
    this.returnInfo = returnInfo;
    this.purchaseOrderNumber = purchaseOrderNumber;
    this.lastMessageSequenceNumber = lastMessageSequenceNumber;
    this.cartRef = cartRef;
    this.cart = cart;
    this.quoteRef = quoteRef;
    this.quote = quote;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public String getCustomerEmail() {
    return customerEmail;
  }

  public void setCustomerEmail(String customerEmail) {
    this.customerEmail = customerEmail;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public List<LineItem> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }

  public List<CustomLineItem> getCustomLineItems() {
    return customLineItems;
  }

  public void setCustomLineItems(List<CustomLineItem> customLineItems) {
    this.customLineItems = customLineItems;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public TaxedPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public DiscountOnTotalPrice getDiscountOnTotalPrice() {
    return discountOnTotalPrice;
  }

  public void setDiscountOnTotalPrice(DiscountOnTotalPrice discountOnTotalPrice) {
    this.discountOnTotalPrice = discountOnTotalPrice;
  }

  public Address getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(Address shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public Address getBillingAddress() {
    return billingAddress;
  }

  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public TaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(TaxMode taxMode) {
    this.taxMode = taxMode;
  }

  public RoundingMode getTaxRoundingMode() {
    return taxRoundingMode;
  }

  public void setTaxRoundingMode(RoundingMode taxRoundingMode) {
    this.taxRoundingMode = taxRoundingMode;
  }

  public TaxCalculationMode getTaxCalculationMode() {
    return taxCalculationMode;
  }

  public void setTaxCalculationMode(TaxCalculationMode taxCalculationMode) {
    this.taxCalculationMode = taxCalculationMode;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public ShippingInfo getShippingInfo() {
    return shippingInfo;
  }

  public void setShippingInfo(ShippingInfo shippingInfo) {
    this.shippingInfo = shippingInfo;
  }

  public List<DiscountCodeInfo> getDiscountCodes() {
    return discountCodes;
  }

  public void setDiscountCodes(List<DiscountCodeInfo> discountCodes) {
    this.discountCodes = discountCodes;
  }

  public List<DirectDiscount> getDirectDiscounts() {
    return directDiscounts;
  }

  public void setDirectDiscounts(List<DirectDiscount> directDiscounts) {
    this.directDiscounts = directDiscounts;
  }

  public DiscountTypeCombination getDiscountTypeCombination() {
    return discountTypeCombination;
  }

  public void setDiscountTypeCombination(DiscountTypeCombination discountTypeCombination) {
    this.discountTypeCombination = discountTypeCombination;
  }

  public List<CartDiscount> getRefusedGifts() {
    return refusedGifts;
  }

  public void setRefusedGifts(List<CartDiscount> refusedGifts) {
    this.refusedGifts = refusedGifts;
  }

  public List<Reference> getRefusedGiftsRefs() {
    return refusedGiftsRefs;
  }

  public void setRefusedGiftsRefs(List<Reference> refusedGiftsRefs) {
    this.refusedGiftsRefs = refusedGiftsRefs;
  }

  public PaymentInfo getPaymentInfo() {
    return paymentInfo;
  }

  public void setPaymentInfo(PaymentInfo paymentInfo) {
    this.paymentInfo = paymentInfo;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public ShippingRateInput getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInput shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public CartOrigin getOrigin() {
    return origin;
  }

  public void setOrigin(CartOrigin origin) {
    this.origin = origin;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public List<Address> getItemShippingAddresses() {
    return itemShippingAddresses;
  }

  public void setItemShippingAddresses(List<Address> itemShippingAddresses) {
    this.itemShippingAddresses = itemShippingAddresses;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public KeyReference getBusinessUnitRef() {
    return businessUnitRef;
  }

  public void setBusinessUnitRef(KeyReference businessUnitRef) {
    this.businessUnitRef = businessUnitRef;
  }

  public List<Shipping> getShipping() {
    return shipping;
  }

  public void setShipping(List<Shipping> shipping) {
    this.shipping = shipping;
  }

  public TaxedPrice getTaxedShippingPrice() {
    return taxedShippingPrice;
  }

  public void setTaxedShippingPrice(TaxedPrice taxedShippingPrice) {
    this.taxedShippingPrice = taxedShippingPrice;
  }

  public ShippingMode getShippingMode() {
    return shippingMode;
  }

  public void setShippingMode(ShippingMode shippingMode) {
    this.shippingMode = shippingMode;
  }

  public CustomFieldsType getShippingCustomFields() {
    return shippingCustomFields;
  }

  public void setShippingCustomFields(CustomFieldsType shippingCustomFields) {
    this.shippingCustomFields = shippingCustomFields;
  }

  public OffsetDateTime getCompletedAt() {
    return completedAt;
  }

  public void setCompletedAt(OffsetDateTime completedAt) {
    this.completedAt = completedAt;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public List<SyncInfo> getSyncInfo() {
    return syncInfo;
  }

  public void setSyncInfo(List<SyncInfo> syncInfo) {
    this.syncInfo = syncInfo;
  }

  public List<ReturnInfo> getReturnInfo() {
    return returnInfo;
  }

  public void setReturnInfo(List<ReturnInfo> returnInfo) {
    this.returnInfo = returnInfo;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public Long getLastMessageSequenceNumber() {
    return lastMessageSequenceNumber;
  }

  public void setLastMessageSequenceNumber(Long lastMessageSequenceNumber) {
    this.lastMessageSequenceNumber = lastMessageSequenceNumber;
  }

  public Reference getCartRef() {
    return cartRef;
  }

  public void setCartRef(Reference cartRef) {
    this.cartRef = cartRef;
  }

  public Cart getCart() {
    return cart;
  }

  public void setCart(Cart cart) {
    this.cart = cart;
  }

  public Reference getQuoteRef() {
    return quoteRef;
  }

  public void setQuoteRef(Reference quoteRef) {
    this.quoteRef = quoteRef;
  }

  public Quote getQuote() {
    return quote;
  }

  public void setQuote(Quote quote) {
    this.quote = quote;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Order{customerId='" + customerId + "', customer='" + customer + "', customerEmail='" + customerEmail + "', anonymousId='" + anonymousId + "', lineItems='" + lineItems + "', customLineItems='" + customLineItems + "', totalPrice='" + totalPrice + "', taxedPrice='" + taxedPrice + "', discountOnTotalPrice='" + discountOnTotalPrice + "', shippingAddress='" + shippingAddress + "', billingAddress='" + billingAddress + "', inventoryMode='" + inventoryMode + "', taxMode='" + taxMode + "', taxRoundingMode='" + taxRoundingMode + "', taxCalculationMode='" + taxCalculationMode + "', customerGroup='" + customerGroup + "', customerGroupRef='" + customerGroupRef + "', country='" + country + "', shippingKey='" + shippingKey + "', shippingInfo='" + shippingInfo + "', discountCodes='" + discountCodes + "', directDiscounts='" + directDiscounts + "', discountTypeCombination='" + discountTypeCombination + "', refusedGifts='" + refusedGifts + "', refusedGiftsRefs='" + refusedGiftsRefs + "', paymentInfo='" + paymentInfo + "', locale='" + locale + "', shippingRateInput='" + shippingRateInput + "', origin='" + origin + "', storeRef='" + storeRef + "', store='" + store + "', itemShippingAddresses='" + itemShippingAddresses + "', businessUnit='" + businessUnit + "', businessUnitRef='" + businessUnitRef + "', shipping='" + shipping + "', taxedShippingPrice='" + taxedShippingPrice + "', shippingMode='" + shippingMode + "', shippingCustomFields='" + shippingCustomFields + "', completedAt='" + completedAt + "', orderNumber='" + orderNumber + "', orderState='" + orderState + "', stateRef='" + stateRef + "', state='" + state + "', shipmentState='" + shipmentState + "', paymentState='" + paymentState + "', syncInfo='" + syncInfo + "', returnInfo='" + returnInfo + "', purchaseOrderNumber='" + purchaseOrderNumber + "', lastMessageSequenceNumber='" + lastMessageSequenceNumber + "', cartRef='" + cartRef + "', cart='" + cart + "', quoteRef='" + quoteRef + "', quote='" + quote + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Order that = (Order) o;
    return Objects.equals(customerId, that.customerId) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(customerEmail, that.customerEmail) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(customLineItems, that.customLineItems) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(discountOnTotalPrice, that.discountOnTotalPrice) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(billingAddress, that.billingAddress) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(taxMode, that.taxMode) &&
        Objects.equals(taxRoundingMode, that.taxRoundingMode) &&
        Objects.equals(taxCalculationMode, that.taxCalculationMode) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(country, that.country) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(shippingInfo, that.shippingInfo) &&
        Objects.equals(discountCodes, that.discountCodes) &&
        Objects.equals(directDiscounts, that.directDiscounts) &&
        Objects.equals(discountTypeCombination, that.discountTypeCombination) &&
        Objects.equals(refusedGifts, that.refusedGifts) &&
        Objects.equals(refusedGiftsRefs, that.refusedGiftsRefs) &&
        Objects.equals(paymentInfo, that.paymentInfo) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(origin, that.origin) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(store, that.store) &&
        Objects.equals(itemShippingAddresses, that.itemShippingAddresses) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnitRef, that.businessUnitRef) &&
        Objects.equals(shipping, that.shipping) &&
        Objects.equals(taxedShippingPrice, that.taxedShippingPrice) &&
        Objects.equals(shippingMode, that.shippingMode) &&
        Objects.equals(shippingCustomFields, that.shippingCustomFields) &&
        Objects.equals(completedAt, that.completedAt) &&
        Objects.equals(orderNumber, that.orderNumber) &&
        Objects.equals(orderState, that.orderState) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(paymentState, that.paymentState) &&
        Objects.equals(syncInfo, that.syncInfo) &&
        Objects.equals(returnInfo, that.returnInfo) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber) &&
        Objects.equals(lastMessageSequenceNumber, that.lastMessageSequenceNumber) &&
        Objects.equals(cartRef, that.cartRef) &&
        Objects.equals(cart, that.cart) &&
        Objects.equals(quoteRef, that.quoteRef) &&
        Objects.equals(quote, that.quote) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerId, customer, customerEmail, anonymousId, lineItems, customLineItems, totalPrice, taxedPrice, discountOnTotalPrice, shippingAddress, billingAddress, inventoryMode, taxMode, taxRoundingMode, taxCalculationMode, customerGroup, customerGroupRef, country, shippingKey, shippingInfo, discountCodes, directDiscounts, discountTypeCombination, refusedGifts, refusedGiftsRefs, paymentInfo, locale, shippingRateInput, origin, storeRef, store, itemShippingAddresses, businessUnit, businessUnitRef, shipping, taxedShippingPrice, shippingMode, shippingCustomFields, completedAt, orderNumber, orderState, stateRef, state, shipmentState, paymentState, syncInfo, returnInfo, purchaseOrderNumber, lastMessageSequenceNumber, cartRef, cart, quoteRef, quote, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customerId;

    private Customer customer;

    private String customerEmail;

    private String anonymousId;

    private List<LineItem> lineItems;

    private List<CustomLineItem> customLineItems;

    private Money totalPrice;

    private TaxedPrice taxedPrice;

    private DiscountOnTotalPrice discountOnTotalPrice;

    private Address shippingAddress;

    private Address billingAddress;

    private InventoryMode inventoryMode;

    private TaxMode taxMode;

    private RoundingMode taxRoundingMode;

    private TaxCalculationMode taxCalculationMode;

    private CustomerGroup customerGroup;

    private Reference customerGroupRef;

    private String country;

    private String shippingKey;

    private ShippingInfo shippingInfo;

    private List<DiscountCodeInfo> discountCodes;

    private List<DirectDiscount> directDiscounts;

    private DiscountTypeCombination discountTypeCombination;

    private List<CartDiscount> refusedGifts;

    private List<Reference> refusedGiftsRefs;

    private PaymentInfo paymentInfo;

    private String locale;

    private ShippingRateInput shippingRateInput;

    private CartOrigin origin;

    private KeyReference storeRef;

    private Store store;

    private List<Address> itemShippingAddresses;

    private BusinessUnit businessUnit;

    private KeyReference businessUnitRef;

    private List<Shipping> shipping;

    private TaxedPrice taxedShippingPrice;

    private ShippingMode shippingMode;

    private CustomFieldsType shippingCustomFields;

    private OffsetDateTime completedAt;

    private String orderNumber;

    private OrderState orderState;

    private Reference stateRef;

    private State state;

    private ShipmentState shipmentState;

    private PaymentState paymentState;

    private List<SyncInfo> syncInfo;

    private List<ReturnInfo> returnInfo;

    private String purchaseOrderNumber;

    private Long lastMessageSequenceNumber;

    private Reference cartRef;

    private Cart cart;

    private Reference quoteRef;

    private Quote quote;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Order build() {
      Order result = new Order();
      result.customerId = this.customerId;
      result.customer = this.customer;
      result.customerEmail = this.customerEmail;
      result.anonymousId = this.anonymousId;
      result.lineItems = this.lineItems;
      result.customLineItems = this.customLineItems;
      result.totalPrice = this.totalPrice;
      result.taxedPrice = this.taxedPrice;
      result.discountOnTotalPrice = this.discountOnTotalPrice;
      result.shippingAddress = this.shippingAddress;
      result.billingAddress = this.billingAddress;
      result.inventoryMode = this.inventoryMode;
      result.taxMode = this.taxMode;
      result.taxRoundingMode = this.taxRoundingMode;
      result.taxCalculationMode = this.taxCalculationMode;
      result.customerGroup = this.customerGroup;
      result.customerGroupRef = this.customerGroupRef;
      result.country = this.country;
      result.shippingKey = this.shippingKey;
      result.shippingInfo = this.shippingInfo;
      result.discountCodes = this.discountCodes;
      result.directDiscounts = this.directDiscounts;
      result.discountTypeCombination = this.discountTypeCombination;
      result.refusedGifts = this.refusedGifts;
      result.refusedGiftsRefs = this.refusedGiftsRefs;
      result.paymentInfo = this.paymentInfo;
      result.locale = this.locale;
      result.shippingRateInput = this.shippingRateInput;
      result.origin = this.origin;
      result.storeRef = this.storeRef;
      result.store = this.store;
      result.itemShippingAddresses = this.itemShippingAddresses;
      result.businessUnit = this.businessUnit;
      result.businessUnitRef = this.businessUnitRef;
      result.shipping = this.shipping;
      result.taxedShippingPrice = this.taxedShippingPrice;
      result.shippingMode = this.shippingMode;
      result.shippingCustomFields = this.shippingCustomFields;
      result.completedAt = this.completedAt;
      result.orderNumber = this.orderNumber;
      result.orderState = this.orderState;
      result.stateRef = this.stateRef;
      result.state = this.state;
      result.shipmentState = this.shipmentState;
      result.paymentState = this.paymentState;
      result.syncInfo = this.syncInfo;
      result.returnInfo = this.returnInfo;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      result.lastMessageSequenceNumber = this.lastMessageSequenceNumber;
      result.cartRef = this.cartRef;
      result.cart = this.cart;
      result.quoteRef = this.quoteRef;
      result.quote = this.quote;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder customerEmail(String customerEmail) {
      this.customerEmail = customerEmail;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder lineItems(List<LineItem> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder customLineItems(List<CustomLineItem> customLineItems) {
      this.customLineItems = customLineItems;
      return this;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder taxedPrice(TaxedPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder discountOnTotalPrice(DiscountOnTotalPrice discountOnTotalPrice) {
      this.discountOnTotalPrice = discountOnTotalPrice;
      return this;
    }

    public Builder shippingAddress(Address shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder billingAddress(Address billingAddress) {
      this.billingAddress = billingAddress;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder taxMode(TaxMode taxMode) {
      this.taxMode = taxMode;
      return this;
    }

    public Builder taxRoundingMode(RoundingMode taxRoundingMode) {
      this.taxRoundingMode = taxRoundingMode;
      return this;
    }

    public Builder taxCalculationMode(TaxCalculationMode taxCalculationMode) {
      this.taxCalculationMode = taxCalculationMode;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder shippingInfo(ShippingInfo shippingInfo) {
      this.shippingInfo = shippingInfo;
      return this;
    }

    public Builder discountCodes(List<DiscountCodeInfo> discountCodes) {
      this.discountCodes = discountCodes;
      return this;
    }

    public Builder directDiscounts(List<DirectDiscount> directDiscounts) {
      this.directDiscounts = directDiscounts;
      return this;
    }

    public Builder discountTypeCombination(DiscountTypeCombination discountTypeCombination) {
      this.discountTypeCombination = discountTypeCombination;
      return this;
    }

    public Builder refusedGifts(List<CartDiscount> refusedGifts) {
      this.refusedGifts = refusedGifts;
      return this;
    }

    public Builder refusedGiftsRefs(List<Reference> refusedGiftsRefs) {
      this.refusedGiftsRefs = refusedGiftsRefs;
      return this;
    }

    public Builder paymentInfo(PaymentInfo paymentInfo) {
      this.paymentInfo = paymentInfo;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInput shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder origin(CartOrigin origin) {
      this.origin = origin;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder itemShippingAddresses(List<Address> itemShippingAddresses) {
      this.itemShippingAddresses = itemShippingAddresses;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder businessUnitRef(KeyReference businessUnitRef) {
      this.businessUnitRef = businessUnitRef;
      return this;
    }

    public Builder shipping(List<Shipping> shipping) {
      this.shipping = shipping;
      return this;
    }

    public Builder taxedShippingPrice(TaxedPrice taxedShippingPrice) {
      this.taxedShippingPrice = taxedShippingPrice;
      return this;
    }

    public Builder shippingMode(ShippingMode shippingMode) {
      this.shippingMode = shippingMode;
      return this;
    }

    public Builder shippingCustomFields(CustomFieldsType shippingCustomFields) {
      this.shippingCustomFields = shippingCustomFields;
      return this;
    }

    public Builder completedAt(OffsetDateTime completedAt) {
      this.completedAt = completedAt;
      return this;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }

    public Builder syncInfo(List<SyncInfo> syncInfo) {
      this.syncInfo = syncInfo;
      return this;
    }

    public Builder returnInfo(List<ReturnInfo> returnInfo) {
      this.returnInfo = returnInfo;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }

    public Builder lastMessageSequenceNumber(Long lastMessageSequenceNumber) {
      this.lastMessageSequenceNumber = lastMessageSequenceNumber;
      return this;
    }

    public Builder cartRef(Reference cartRef) {
      this.cartRef = cartRef;
      return this;
    }

    public Builder cart(Cart cart) {
      this.cart = cart;
      return this;
    }

    public Builder quoteRef(Reference quoteRef) {
      this.quoteRef = quoteRef;
      return this;
    }

    public Builder quote(Quote quote) {
      this.quote = quote;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
