package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderBusinessUnitSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String businessUnit;

  private String oldBusinessUnit;

  private String type;

  public OrderBusinessUnitSet() {
  }

  public OrderBusinessUnitSet(String businessUnit, String oldBusinessUnit, String type) {
    this.businessUnit = businessUnit;
    this.oldBusinessUnit = oldBusinessUnit;
    this.type = type;
  }

  public String getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(String businessUnit) {
    this.businessUnit = businessUnit;
  }

  public String getOldBusinessUnit() {
    return oldBusinessUnit;
  }

  public void setOldBusinessUnit(String oldBusinessUnit) {
    this.oldBusinessUnit = oldBusinessUnit;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderBusinessUnitSet{businessUnit='" + businessUnit + "', oldBusinessUnit='" + oldBusinessUnit + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderBusinessUnitSet that = (OrderBusinessUnitSet) o;
    return Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(oldBusinessUnit, that.oldBusinessUnit) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessUnit, oldBusinessUnit, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String businessUnit;

    private String oldBusinessUnit;

    private String type;

    public OrderBusinessUnitSet build() {
      OrderBusinessUnitSet result = new OrderBusinessUnitSet();
      result.businessUnit = this.businessUnit;
      result.oldBusinessUnit = this.oldBusinessUnit;
      result.type = this.type;
      return result;
    }

    public Builder businessUnit(String businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder oldBusinessUnit(String oldBusinessUnit) {
      this.oldBusinessUnit = oldBusinessUnit;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
