package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderCartCommand {
  private String id;

  private ResourceIdentifierInput cart;

  private Long version;

  private String purchaseOrderNumber;

  private PaymentState paymentState;

  private OrderState orderState;

  private ResourceIdentifierInput state;

  private ShipmentState shipmentState;

  private String orderNumber;

  private CustomFieldsDraft custom;

  public OrderCartCommand() {
  }

  public OrderCartCommand(String id, ResourceIdentifierInput cart, Long version,
      String purchaseOrderNumber, PaymentState paymentState, OrderState orderState,
      ResourceIdentifierInput state, ShipmentState shipmentState, String orderNumber,
      CustomFieldsDraft custom) {
    this.id = id;
    this.cart = cart;
    this.version = version;
    this.purchaseOrderNumber = purchaseOrderNumber;
    this.paymentState = paymentState;
    this.orderState = orderState;
    this.state = state;
    this.shipmentState = shipmentState;
    this.orderNumber = orderNumber;
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public ResourceIdentifierInput getCart() {
    return cart;
  }

  public void setCart(ResourceIdentifierInput cart) {
    this.cart = cart;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public ResourceIdentifierInput getState() {
    return state;
  }

  public void setState(ResourceIdentifierInput state) {
    this.state = state;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "OrderCartCommand{id='" + id + "', cart='" + cart + "', version='" + version + "', purchaseOrderNumber='" + purchaseOrderNumber + "', paymentState='" + paymentState + "', orderState='" + orderState + "', state='" + state + "', shipmentState='" + shipmentState + "', orderNumber='" + orderNumber + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCartCommand that = (OrderCartCommand) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(cart, that.cart) &&
        Objects.equals(version, that.version) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber) &&
        Objects.equals(paymentState, that.paymentState) &&
        Objects.equals(orderState, that.orderState) &&
        Objects.equals(state, that.state) &&
        Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(orderNumber, that.orderNumber) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, cart, version, purchaseOrderNumber, paymentState, orderState, state, shipmentState, orderNumber, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private ResourceIdentifierInput cart;

    private Long version;

    private String purchaseOrderNumber;

    private PaymentState paymentState;

    private OrderState orderState;

    private ResourceIdentifierInput state;

    private ShipmentState shipmentState;

    private String orderNumber;

    private CustomFieldsDraft custom;

    public OrderCartCommand build() {
      OrderCartCommand result = new OrderCartCommand();
      result.id = this.id;
      result.cart = this.cart;
      result.version = this.version;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      result.paymentState = this.paymentState;
      result.orderState = this.orderState;
      result.state = this.state;
      result.shipmentState = this.shipmentState;
      result.orderNumber = this.orderNumber;
      result.custom = this.custom;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder cart(ResourceIdentifierInput cart) {
      this.cart = cart;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }

    public Builder state(ResourceIdentifierInput state) {
      this.state = state;
      return this;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
