package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomLineItemAdded implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private CustomLineItem customLineItem;

  private String type;

  public OrderCustomLineItemAdded() {
  }

  public OrderCustomLineItemAdded(CustomLineItem customLineItem, String type) {
    this.customLineItem = customLineItem;
    this.type = type;
  }

  public CustomLineItem getCustomLineItem() {
    return customLineItem;
  }

  public void setCustomLineItem(CustomLineItem customLineItem) {
    this.customLineItem = customLineItem;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomLineItemAdded{customLineItem='" + customLineItem + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomLineItemAdded that = (OrderCustomLineItemAdded) o;
    return Objects.equals(customLineItem, that.customLineItem) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItem, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomLineItem customLineItem;

    private String type;

    public OrderCustomLineItemAdded build() {
      OrderCustomLineItemAdded result = new OrderCustomLineItemAdded();
      result.customLineItem = this.customLineItem;
      result.type = this.type;
      return result;
    }

    public Builder customLineItem(CustomLineItem customLineItem) {
      this.customLineItem = customLineItem;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
