package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomLineItemQuantityChanged implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String customLineItemId;

  private String customLineItemKey;

  private Long quantity;

  private Long oldQuantity;

  private String type;

  public OrderCustomLineItemQuantityChanged() {
  }

  public OrderCustomLineItemQuantityChanged(String customLineItemId, String customLineItemKey,
      Long quantity, Long oldQuantity, String type) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.quantity = quantity;
    this.oldQuantity = oldQuantity;
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Long getOldQuantity() {
    return oldQuantity;
  }

  public void setOldQuantity(Long oldQuantity) {
    this.oldQuantity = oldQuantity;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomLineItemQuantityChanged{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', quantity='" + quantity + "', oldQuantity='" + oldQuantity + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomLineItemQuantityChanged that = (OrderCustomLineItemQuantityChanged) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(oldQuantity, that.oldQuantity) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, quantity, oldQuantity, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private Long quantity;

    private Long oldQuantity;

    private String type;

    public OrderCustomLineItemQuantityChanged build() {
      OrderCustomLineItemQuantityChanged result = new OrderCustomLineItemQuantityChanged();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.quantity = this.quantity;
      result.oldQuantity = this.oldQuantity;
      result.type = this.type;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder oldQuantity(Long oldQuantity) {
      this.oldQuantity = oldQuantity;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
