package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomTypeRemoved implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String previousTypeId;

  private String type;

  public OrderCustomTypeRemoved() {
  }

  public OrderCustomTypeRemoved(String previousTypeId, String type) {
    this.previousTypeId = previousTypeId;
    this.type = type;
  }

  public String getPreviousTypeId() {
    return previousTypeId;
  }

  public void setPreviousTypeId(String previousTypeId) {
    this.previousTypeId = previousTypeId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomTypeRemoved{previousTypeId='" + previousTypeId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomTypeRemoved that = (OrderCustomTypeRemoved) o;
    return Objects.equals(previousTypeId, that.previousTypeId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(previousTypeId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String previousTypeId;

    private String type;

    public OrderCustomTypeRemoved build() {
      OrderCustomTypeRemoved result = new OrderCustomTypeRemoved();
      result.previousTypeId = this.previousTypeId;
      result.type = this.type;
      return result;
    }

    public Builder previousTypeId(String previousTypeId) {
      this.previousTypeId = previousTypeId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
