package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomerEmailSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String email;

  private String oldEmail;

  private String type;

  public OrderCustomerEmailSet() {
  }

  public OrderCustomerEmailSet(String email, String oldEmail, String type) {
    this.email = email;
    this.oldEmail = oldEmail;
    this.type = type;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getOldEmail() {
    return oldEmail;
  }

  public void setOldEmail(String oldEmail) {
    this.oldEmail = oldEmail;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomerEmailSet{email='" + email + "', oldEmail='" + oldEmail + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomerEmailSet that = (OrderCustomerEmailSet) o;
    return Objects.equals(email, that.email) &&
        Objects.equals(oldEmail, that.oldEmail) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, oldEmail, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String email;

    private String oldEmail;

    private String type;

    public OrderCustomerEmailSet build() {
      OrderCustomerEmailSet result = new OrderCustomerEmailSet();
      result.email = this.email;
      result.oldEmail = this.oldEmail;
      result.type = this.type;
      return result;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder oldEmail(String oldEmail) {
      this.oldEmail = oldEmail;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
