package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomerGroupSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private CustomerGroup customerGroup;

  private CustomerGroup oldCustomerGroup;

  private Reference customerGroupRef;

  private Reference oldCustomerGroupRef;

  private String type;

  public OrderCustomerGroupSet() {
  }

  public OrderCustomerGroupSet(CustomerGroup customerGroup, CustomerGroup oldCustomerGroup,
      Reference customerGroupRef, Reference oldCustomerGroupRef, String type) {
    this.customerGroup = customerGroup;
    this.oldCustomerGroup = oldCustomerGroup;
    this.customerGroupRef = customerGroupRef;
    this.oldCustomerGroupRef = oldCustomerGroupRef;
    this.type = type;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public CustomerGroup getOldCustomerGroup() {
    return oldCustomerGroup;
  }

  public void setOldCustomerGroup(CustomerGroup oldCustomerGroup) {
    this.oldCustomerGroup = oldCustomerGroup;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public Reference getOldCustomerGroupRef() {
    return oldCustomerGroupRef;
  }

  public void setOldCustomerGroupRef(Reference oldCustomerGroupRef) {
    this.oldCustomerGroupRef = oldCustomerGroupRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomerGroupSet{customerGroup='" + customerGroup + "', oldCustomerGroup='" + oldCustomerGroup + "', customerGroupRef='" + customerGroupRef + "', oldCustomerGroupRef='" + oldCustomerGroupRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomerGroupSet that = (OrderCustomerGroupSet) o;
    return Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(oldCustomerGroup, that.oldCustomerGroup) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(oldCustomerGroupRef, that.oldCustomerGroupRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroup, oldCustomerGroup, customerGroupRef, oldCustomerGroupRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerGroup customerGroup;

    private CustomerGroup oldCustomerGroup;

    private Reference customerGroupRef;

    private Reference oldCustomerGroupRef;

    private String type;

    public OrderCustomerGroupSet build() {
      OrderCustomerGroupSet result = new OrderCustomerGroupSet();
      result.customerGroup = this.customerGroup;
      result.oldCustomerGroup = this.oldCustomerGroup;
      result.customerGroupRef = this.customerGroupRef;
      result.oldCustomerGroupRef = this.oldCustomerGroupRef;
      result.type = this.type;
      return result;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder oldCustomerGroup(CustomerGroup oldCustomerGroup) {
      this.oldCustomerGroup = oldCustomerGroup;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder oldCustomerGroupRef(Reference oldCustomerGroupRef) {
      this.oldCustomerGroupRef = oldCustomerGroupRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
