package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderCustomerSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Customer customer;

  private Customer oldCustomer;

  private CustomerGroup customerGroup;

  private CustomerGroup oldCustomerGroup;

  private Reference customerRef;

  private Reference oldCustomerRef;

  private Reference customerGroupRef;

  private Reference oldCustomerGroupRef;

  private String type;

  public OrderCustomerSet() {
  }

  public OrderCustomerSet(Customer customer, Customer oldCustomer, CustomerGroup customerGroup,
      CustomerGroup oldCustomerGroup, Reference customerRef, Reference oldCustomerRef,
      Reference customerGroupRef, Reference oldCustomerGroupRef, String type) {
    this.customer = customer;
    this.oldCustomer = oldCustomer;
    this.customerGroup = customerGroup;
    this.oldCustomerGroup = oldCustomerGroup;
    this.customerRef = customerRef;
    this.oldCustomerRef = oldCustomerRef;
    this.customerGroupRef = customerGroupRef;
    this.oldCustomerGroupRef = oldCustomerGroupRef;
    this.type = type;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public Customer getOldCustomer() {
    return oldCustomer;
  }

  public void setOldCustomer(Customer oldCustomer) {
    this.oldCustomer = oldCustomer;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public CustomerGroup getOldCustomerGroup() {
    return oldCustomerGroup;
  }

  public void setOldCustomerGroup(CustomerGroup oldCustomerGroup) {
    this.oldCustomerGroup = oldCustomerGroup;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Reference getOldCustomerRef() {
    return oldCustomerRef;
  }

  public void setOldCustomerRef(Reference oldCustomerRef) {
    this.oldCustomerRef = oldCustomerRef;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public Reference getOldCustomerGroupRef() {
    return oldCustomerGroupRef;
  }

  public void setOldCustomerGroupRef(Reference oldCustomerGroupRef) {
    this.oldCustomerGroupRef = oldCustomerGroupRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderCustomerSet{customer='" + customer + "', oldCustomer='" + oldCustomer + "', customerGroup='" + customerGroup + "', oldCustomerGroup='" + oldCustomerGroup + "', customerRef='" + customerRef + "', oldCustomerRef='" + oldCustomerRef + "', customerGroupRef='" + customerGroupRef + "', oldCustomerGroupRef='" + oldCustomerGroupRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderCustomerSet that = (OrderCustomerSet) o;
    return Objects.equals(customer, that.customer) &&
        Objects.equals(oldCustomer, that.oldCustomer) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(oldCustomerGroup, that.oldCustomerGroup) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(oldCustomerRef, that.oldCustomerRef) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(oldCustomerGroupRef, that.oldCustomerGroupRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, oldCustomer, customerGroup, oldCustomerGroup, customerRef, oldCustomerRef, customerGroupRef, oldCustomerGroupRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Customer customer;

    private Customer oldCustomer;

    private CustomerGroup customerGroup;

    private CustomerGroup oldCustomerGroup;

    private Reference customerRef;

    private Reference oldCustomerRef;

    private Reference customerGroupRef;

    private Reference oldCustomerGroupRef;

    private String type;

    public OrderCustomerSet build() {
      OrderCustomerSet result = new OrderCustomerSet();
      result.customer = this.customer;
      result.oldCustomer = this.oldCustomer;
      result.customerGroup = this.customerGroup;
      result.oldCustomerGroup = this.oldCustomerGroup;
      result.customerRef = this.customerRef;
      result.oldCustomerRef = this.oldCustomerRef;
      result.customerGroupRef = this.customerGroupRef;
      result.oldCustomerGroupRef = this.oldCustomerGroupRef;
      result.type = this.type;
      return result;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder oldCustomer(Customer oldCustomer) {
      this.oldCustomer = oldCustomer;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder oldCustomerGroup(CustomerGroup oldCustomerGroup) {
      this.oldCustomerGroup = oldCustomerGroup;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder oldCustomerRef(Reference oldCustomerRef) {
      this.oldCustomerRef = oldCustomerRef;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder oldCustomerGroupRef(Reference oldCustomerGroupRef) {
      this.oldCustomerGroupRef = oldCustomerGroupRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
