package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderDiscountCodeStateSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private DiscountCodeState state;

  private DiscountCodeState oldState;

  private DiscountCode discountCode;

  private Reference discountCodeRef;

  private String type;

  public OrderDiscountCodeStateSet() {
  }

  public OrderDiscountCodeStateSet(DiscountCodeState state, DiscountCodeState oldState,
      DiscountCode discountCode, Reference discountCodeRef, String type) {
    this.state = state;
    this.oldState = oldState;
    this.discountCode = discountCode;
    this.discountCodeRef = discountCodeRef;
    this.type = type;
  }

  public DiscountCodeState getState() {
    return state;
  }

  public void setState(DiscountCodeState state) {
    this.state = state;
  }

  public DiscountCodeState getOldState() {
    return oldState;
  }

  public void setOldState(DiscountCodeState oldState) {
    this.oldState = oldState;
  }

  public DiscountCode getDiscountCode() {
    return discountCode;
  }

  public void setDiscountCode(DiscountCode discountCode) {
    this.discountCode = discountCode;
  }

  public Reference getDiscountCodeRef() {
    return discountCodeRef;
  }

  public void setDiscountCodeRef(Reference discountCodeRef) {
    this.discountCodeRef = discountCodeRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderDiscountCodeStateSet{state='" + state + "', oldState='" + oldState + "', discountCode='" + discountCode + "', discountCodeRef='" + discountCodeRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderDiscountCodeStateSet that = (OrderDiscountCodeStateSet) o;
    return Objects.equals(state, that.state) &&
        Objects.equals(oldState, that.oldState) &&
        Objects.equals(discountCode, that.discountCode) &&
        Objects.equals(discountCodeRef, that.discountCodeRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(state, oldState, discountCode, discountCodeRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private DiscountCodeState state;

    private DiscountCodeState oldState;

    private DiscountCode discountCode;

    private Reference discountCodeRef;

    private String type;

    public OrderDiscountCodeStateSet build() {
      OrderDiscountCodeStateSet result = new OrderDiscountCodeStateSet();
      result.state = this.state;
      result.oldState = this.oldState;
      result.discountCode = this.discountCode;
      result.discountCodeRef = this.discountCodeRef;
      result.type = this.type;
      return result;
    }

    public Builder state(DiscountCodeState state) {
      this.state = state;
      return this;
    }

    public Builder oldState(DiscountCodeState oldState) {
      this.oldState = oldState;
      return this;
    }

    public Builder discountCode(DiscountCode discountCode) {
      this.discountCode = discountCode;
      return this;
    }

    public Builder discountCodeRef(Reference discountCodeRef) {
      this.discountCodeRef = discountCodeRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
