package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class OrderEditDraft {
  private String key;

  private ReferenceInput resource;

  private List<StagedOrderUpdateAction> stagedActions;

  private CustomFieldsDraft custom;

  private String comment;

  private Boolean dryRun;

  public OrderEditDraft() {
  }

  public OrderEditDraft(String key, ReferenceInput resource,
      List<StagedOrderUpdateAction> stagedActions, CustomFieldsDraft custom, String comment,
      Boolean dryRun) {
    this.key = key;
    this.resource = resource;
    this.stagedActions = stagedActions;
    this.custom = custom;
    this.comment = comment;
    this.dryRun = dryRun;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ReferenceInput getResource() {
    return resource;
  }

  public void setResource(ReferenceInput resource) {
    this.resource = resource;
  }

  public List<StagedOrderUpdateAction> getStagedActions() {
    return stagedActions;
  }

  public void setStagedActions(List<StagedOrderUpdateAction> stagedActions) {
    this.stagedActions = stagedActions;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public Boolean getDryRun() {
    return dryRun;
  }

  public void setDryRun(Boolean dryRun) {
    this.dryRun = dryRun;
  }

  @Override
  public String toString() {
    return "OrderEditDraft{key='" + key + "', resource='" + resource + "', stagedActions='" + stagedActions + "', custom='" + custom + "', comment='" + comment + "', dryRun='" + dryRun + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderEditDraft that = (OrderEditDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(resource, that.resource) &&
        Objects.equals(stagedActions, that.stagedActions) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(comment, that.comment) &&
        Objects.equals(dryRun, that.dryRun);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, resource, stagedActions, custom, comment, dryRun);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ReferenceInput resource;

    private List<StagedOrderUpdateAction> stagedActions;

    private CustomFieldsDraft custom;

    private String comment;

    private Boolean dryRun;

    public OrderEditDraft build() {
      OrderEditDraft result = new OrderEditDraft();
      result.key = this.key;
      result.resource = this.resource;
      result.stagedActions = this.stagedActions;
      result.custom = this.custom;
      result.comment = this.comment;
      result.dryRun = this.dryRun;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder resource(ReferenceInput resource) {
      this.resource = resource;
      return this;
    }

    public Builder stagedActions(List<StagedOrderUpdateAction> stagedActions) {
      this.stagedActions = stagedActions;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }

    public Builder dryRun(Boolean dryRun) {
      this.dryRun = dryRun;
      return this;
    }
  }
}
