package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = Applied.class, name = "Applied"),
    @JsonSubTypes.Type(value = NotProcessed.class, name = "NotProcessed"),
    @JsonSubTypes.Type(value = PreviewFailure.class, name = "PreviewFailure"),
    @JsonSubTypes.Type(value = PreviewSuccess.class, name = "PreviewSuccess")
})
public interface OrderEditResult {
  String getType();

  void setType(String type);
}
