package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderExcerpt {
  private Money totalPrice;

  private TaxedPrice taxedPrice;

  private Long version;

  public OrderExcerpt() {
  }

  public OrderExcerpt(Money totalPrice, TaxedPrice taxedPrice, Long version) {
    this.totalPrice = totalPrice;
    this.taxedPrice = taxedPrice;
    this.version = version;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public TaxedPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  @Override
  public String toString() {
    return "OrderExcerpt{totalPrice='" + totalPrice + "', taxedPrice='" + taxedPrice + "', version='" + version + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderExcerpt that = (OrderExcerpt) o;
    return Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(version, that.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalPrice, taxedPrice, version);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Money totalPrice;

    private TaxedPrice taxedPrice;

    private Long version;

    public OrderExcerpt build() {
      OrderExcerpt result = new OrderExcerpt();
      result.totalPrice = this.totalPrice;
      result.taxedPrice = this.taxedPrice;
      result.version = this.version;
      return result;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder taxedPrice(TaxedPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }
  }
}
