package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderLineItemAdded implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private LineItem lineItem;

  private Long addedQuantity;

  private String type;

  public OrderLineItemAdded() {
  }

  public OrderLineItemAdded(LineItem lineItem, Long addedQuantity, String type) {
    this.lineItem = lineItem;
    this.addedQuantity = addedQuantity;
    this.type = type;
  }

  public LineItem getLineItem() {
    return lineItem;
  }

  public void setLineItem(LineItem lineItem) {
    this.lineItem = lineItem;
  }

  public Long getAddedQuantity() {
    return addedQuantity;
  }

  public void setAddedQuantity(Long addedQuantity) {
    this.addedQuantity = addedQuantity;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderLineItemAdded{lineItem='" + lineItem + "', addedQuantity='" + addedQuantity + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderLineItemAdded that = (OrderLineItemAdded) o;
    return Objects.equals(lineItem, that.lineItem) &&
        Objects.equals(addedQuantity, that.addedQuantity) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItem, addedQuantity, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private LineItem lineItem;

    private Long addedQuantity;

    private String type;

    public OrderLineItemAdded build() {
      OrderLineItemAdded result = new OrderLineItemAdded();
      result.lineItem = this.lineItem;
      result.addedQuantity = this.addedQuantity;
      result.type = this.type;
      return result;
    }

    public Builder lineItem(LineItem lineItem) {
      this.lineItem = lineItem;
      return this;
    }

    public Builder addedQuantity(Long addedQuantity) {
      this.addedQuantity = addedQuantity;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
