package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderLineItemDiscountSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String lineItemId;

  private String lineItemKey;

  private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

  private Money totalPrice;

  private List<MethodTaxedPrice> taxedPricePortions;

  private TaxedItemPrice taxedPrice;

  private String type;

  public OrderLineItemDiscountSet() {
  }

  public OrderLineItemDiscountSet(String lineItemId, String lineItemKey,
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity, Money totalPrice,
      List<MethodTaxedPrice> taxedPricePortions, TaxedItemPrice taxedPrice, String type) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.discountedPricePerQuantity = discountedPricePerQuantity;
    this.totalPrice = totalPrice;
    this.taxedPricePortions = taxedPricePortions;
    this.taxedPrice = taxedPrice;
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public List<DiscountedLineItemPriceForQuantity> getDiscountedPricePerQuantity() {
    return discountedPricePerQuantity;
  }

  public void setDiscountedPricePerQuantity(
      List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
    this.discountedPricePerQuantity = discountedPricePerQuantity;
  }

  public Money getTotalPrice() {
    return totalPrice;
  }

  public void setTotalPrice(Money totalPrice) {
    this.totalPrice = totalPrice;
  }

  public List<MethodTaxedPrice> getTaxedPricePortions() {
    return taxedPricePortions;
  }

  public void setTaxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
    this.taxedPricePortions = taxedPricePortions;
  }

  public TaxedItemPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedItemPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderLineItemDiscountSet{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', discountedPricePerQuantity='" + discountedPricePerQuantity + "', totalPrice='" + totalPrice + "', taxedPricePortions='" + taxedPricePortions + "', taxedPrice='" + taxedPrice + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderLineItemDiscountSet that = (OrderLineItemDiscountSet) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(discountedPricePerQuantity, that.discountedPricePerQuantity) &&
        Objects.equals(totalPrice, that.totalPrice) &&
        Objects.equals(taxedPricePortions, that.taxedPricePortions) &&
        Objects.equals(taxedPrice, that.taxedPrice) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, discountedPricePerQuantity, totalPrice, taxedPricePortions, taxedPrice, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity;

    private Money totalPrice;

    private List<MethodTaxedPrice> taxedPricePortions;

    private TaxedItemPrice taxedPrice;

    private String type;

    public OrderLineItemDiscountSet build() {
      OrderLineItemDiscountSet result = new OrderLineItemDiscountSet();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.discountedPricePerQuantity = this.discountedPricePerQuantity;
      result.totalPrice = this.totalPrice;
      result.taxedPricePortions = this.taxedPricePortions;
      result.taxedPrice = this.taxedPrice;
      result.type = this.type;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder discountedPricePerQuantity(
        List<DiscountedLineItemPriceForQuantity> discountedPricePerQuantity) {
      this.discountedPricePerQuantity = discountedPricePerQuantity;
      return this;
    }

    public Builder totalPrice(Money totalPrice) {
      this.totalPrice = totalPrice;
      return this;
    }

    public Builder taxedPricePortions(List<MethodTaxedPrice> taxedPricePortions) {
      this.taxedPricePortions = taxedPricePortions;
      return this;
    }

    public Builder taxedPrice(TaxedItemPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
