package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderLineItemDistributionChannelSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String lineItemId;

  private String lineItemKey;

  private Channel distributionChannel;

  private Reference distributionChannelRef;

  private String type;

  public OrderLineItemDistributionChannelSet() {
  }

  public OrderLineItemDistributionChannelSet(String lineItemId, String lineItemKey,
      Channel distributionChannel, Reference distributionChannelRef, String type) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.distributionChannel = distributionChannel;
    this.distributionChannelRef = distributionChannelRef;
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public Channel getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(Channel distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public Reference getDistributionChannelRef() {
    return distributionChannelRef;
  }

  public void setDistributionChannelRef(Reference distributionChannelRef) {
    this.distributionChannelRef = distributionChannelRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderLineItemDistributionChannelSet{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', distributionChannel='" + distributionChannel + "', distributionChannelRef='" + distributionChannelRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderLineItemDistributionChannelSet that = (OrderLineItemDistributionChannelSet) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(distributionChannelRef, that.distributionChannelRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, distributionChannel, distributionChannelRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private Channel distributionChannel;

    private Reference distributionChannelRef;

    private String type;

    public OrderLineItemDistributionChannelSet build() {
      OrderLineItemDistributionChannelSet result = new OrderLineItemDistributionChannelSet();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.distributionChannel = this.distributionChannel;
      result.distributionChannelRef = this.distributionChannelRef;
      result.type = this.type;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder distributionChannel(Channel distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder distributionChannelRef(Reference distributionChannelRef) {
      this.distributionChannelRef = distributionChannelRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
