package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CustomLineItemStateTransition.class, name = "CustomLineItemStateTransition"),
    @JsonSubTypes.Type(value = DeliveryAdded.class, name = "DeliveryAdded"),
    @JsonSubTypes.Type(value = DeliveryAddressSet.class, name = "DeliveryAddressSet"),
    @JsonSubTypes.Type(value = DeliveryItemsUpdated.class, name = "DeliveryItemsUpdated"),
    @JsonSubTypes.Type(value = DeliveryRemoved.class, name = "DeliveryRemoved"),
    @JsonSubTypes.Type(value = LineItemStateTransition.class, name = "LineItemStateTransition"),
    @JsonSubTypes.Type(value = OrderBillingAddressSet.class, name = "OrderBillingAddressSet"),
    @JsonSubTypes.Type(value = OrderBusinessUnitSet.class, name = "OrderBusinessUnitSet"),
    @JsonSubTypes.Type(value = OrderCreated.class, name = "OrderCreated"),
    @JsonSubTypes.Type(value = OrderCustomFieldAdded.class, name = "OrderCustomFieldAdded"),
    @JsonSubTypes.Type(value = OrderCustomFieldChanged.class, name = "OrderCustomFieldChanged"),
    @JsonSubTypes.Type(value = OrderCustomFieldRemoved.class, name = "OrderCustomFieldRemoved"),
    @JsonSubTypes.Type(value = OrderCustomLineItemAdded.class, name = "OrderCustomLineItemAdded"),
    @JsonSubTypes.Type(value = OrderCustomLineItemDiscountSet.class, name = "OrderCustomLineItemDiscountSet"),
    @JsonSubTypes.Type(value = OrderCustomLineItemQuantityChanged.class, name = "OrderCustomLineItemQuantityChanged"),
    @JsonSubTypes.Type(value = OrderCustomLineItemRemoved.class, name = "OrderCustomLineItemRemoved"),
    @JsonSubTypes.Type(value = OrderCustomTypeRemoved.class, name = "OrderCustomTypeRemoved"),
    @JsonSubTypes.Type(value = OrderCustomTypeSet.class, name = "OrderCustomTypeSet"),
    @JsonSubTypes.Type(value = OrderCustomerEmailSet.class, name = "OrderCustomerEmailSet"),
    @JsonSubTypes.Type(value = OrderCustomerGroupSet.class, name = "OrderCustomerGroupSet"),
    @JsonSubTypes.Type(value = OrderCustomerSet.class, name = "OrderCustomerSet"),
    @JsonSubTypes.Type(value = OrderDeleted.class, name = "OrderDeleted"),
    @JsonSubTypes.Type(value = OrderDiscountCodeAdded.class, name = "OrderDiscountCodeAdded"),
    @JsonSubTypes.Type(value = OrderDiscountCodeRemoved.class, name = "OrderDiscountCodeRemoved"),
    @JsonSubTypes.Type(value = OrderDiscountCodeStateSet.class, name = "OrderDiscountCodeStateSet"),
    @JsonSubTypes.Type(value = OrderEditApplied.class, name = "OrderEditApplied"),
    @JsonSubTypes.Type(value = OrderImported.class, name = "OrderImported"),
    @JsonSubTypes.Type(value = OrderLineItemAdded.class, name = "OrderLineItemAdded"),
    @JsonSubTypes.Type(value = OrderLineItemDiscountSet.class, name = "OrderLineItemDiscountSet"),
    @JsonSubTypes.Type(value = OrderLineItemDistributionChannelSet.class, name = "OrderLineItemDistributionChannelSet"),
    @JsonSubTypes.Type(value = OrderLineItemRemoved.class, name = "OrderLineItemRemoved"),
    @JsonSubTypes.Type(value = OrderPaymentAdded.class, name = "OrderPaymentAdded"),
    @JsonSubTypes.Type(value = OrderPaymentRemoved.class, name = "OrderPaymentRemoved"),
    @JsonSubTypes.Type(value = OrderPaymentStateChanged.class, name = "OrderPaymentStateChanged"),
    @JsonSubTypes.Type(value = OrderReturnShipmentStateChanged.class, name = "OrderReturnShipmentStateChanged"),
    @JsonSubTypes.Type(value = OrderShipmentStateChanged.class, name = "OrderShipmentStateChanged"),
    @JsonSubTypes.Type(value = OrderShippingAddressSet.class, name = "OrderShippingAddressSet"),
    @JsonSubTypes.Type(value = OrderShippingContainerSet.class, name = "OrderShippingContainerSet"),
    @JsonSubTypes.Type(value = OrderShippingInfoSet.class, name = "OrderShippingInfoSet"),
    @JsonSubTypes.Type(value = OrderShippingRateInputSet.class, name = "OrderShippingRateInputSet"),
    @JsonSubTypes.Type(value = OrderShippingUpdated.class, name = "OrderShippingUpdated"),
    @JsonSubTypes.Type(value = OrderStateChanged.class, name = "OrderStateChanged"),
    @JsonSubTypes.Type(value = OrderStateTransition.class, name = "OrderStateTransition"),
    @JsonSubTypes.Type(value = OrderStoreSet.class, name = "OrderStoreSet"),
    @JsonSubTypes.Type(value = ParcelAddedToDelivery.class, name = "ParcelAddedToDelivery"),
    @JsonSubTypes.Type(value = ParcelItemsUpdated.class, name = "ParcelItemsUpdated"),
    @JsonSubTypes.Type(value = ParcelMeasurementsUpdated.class, name = "ParcelMeasurementsUpdated"),
    @JsonSubTypes.Type(value = ParcelRemovedFromDelivery.class, name = "ParcelRemovedFromDelivery"),
    @JsonSubTypes.Type(value = ParcelTrackingDataUpdated.class, name = "ParcelTrackingDataUpdated"),
    @JsonSubTypes.Type(value = PurchaseOrderNumberSet.class, name = "PurchaseOrderNumberSet"),
    @JsonSubTypes.Type(value = ReturnInfoAdded.class, name = "ReturnInfoAdded"),
    @JsonSubTypes.Type(value = ReturnInfoSet.class, name = "ReturnInfoSet")
})
public interface OrderMessagePayload {
  String getType();

  void setType(String type);
}
