package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderMyCartCommand {
  private String id;

  private Long version;

  public OrderMyCartCommand() {
  }

  public OrderMyCartCommand(String id, Long version) {
    this.id = id;
    this.version = version;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  @Override
  public String toString() {
    return "OrderMyCartCommand{id='" + id + "', version='" + version + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderMyCartCommand that = (OrderMyCartCommand) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    public OrderMyCartCommand build() {
      OrderMyCartCommand result = new OrderMyCartCommand();
      result.id = this.id;
      result.version = this.version;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }
  }
}
