package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderPaymentAdded implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Reference paymentRef;

  private String type;

  public OrderPaymentAdded() {
  }

  public OrderPaymentAdded(Reference paymentRef, String type) {
    this.paymentRef = paymentRef;
    this.type = type;
  }

  public Reference getPaymentRef() {
    return paymentRef;
  }

  public void setPaymentRef(Reference paymentRef) {
    this.paymentRef = paymentRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderPaymentAdded{paymentRef='" + paymentRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderPaymentAdded that = (OrderPaymentAdded) o;
    return Objects.equals(paymentRef, that.paymentRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference paymentRef;

    private String type;

    public OrderPaymentAdded build() {
      OrderPaymentAdded result = new OrderPaymentAdded();
      result.paymentRef = this.paymentRef;
      result.type = this.type;
      return result;
    }

    public Builder paymentRef(Reference paymentRef) {
      this.paymentRef = paymentRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
