package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderPaymentRemoved implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Reference paymentRef;

  private Boolean removedPaymentInfo;

  private String type;

  public OrderPaymentRemoved() {
  }

  public OrderPaymentRemoved(Reference paymentRef, Boolean removedPaymentInfo, String type) {
    this.paymentRef = paymentRef;
    this.removedPaymentInfo = removedPaymentInfo;
    this.type = type;
  }

  public Reference getPaymentRef() {
    return paymentRef;
  }

  public void setPaymentRef(Reference paymentRef) {
    this.paymentRef = paymentRef;
  }

  public Boolean getRemovedPaymentInfo() {
    return removedPaymentInfo;
  }

  public void setRemovedPaymentInfo(Boolean removedPaymentInfo) {
    this.removedPaymentInfo = removedPaymentInfo;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderPaymentRemoved{paymentRef='" + paymentRef + "', removedPaymentInfo='" + removedPaymentInfo + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderPaymentRemoved that = (OrderPaymentRemoved) o;
    return Objects.equals(paymentRef, that.paymentRef) &&
        Objects.equals(removedPaymentInfo, that.removedPaymentInfo) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentRef, removedPaymentInfo, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference paymentRef;

    private Boolean removedPaymentInfo;

    private String type;

    public OrderPaymentRemoved build() {
      OrderPaymentRemoved result = new OrderPaymentRemoved();
      result.paymentRef = this.paymentRef;
      result.removedPaymentInfo = this.removedPaymentInfo;
      result.type = this.type;
      return result;
    }

    public Builder paymentRef(Reference paymentRef) {
      this.paymentRef = paymentRef;
      return this;
    }

    public Builder removedPaymentInfo(Boolean removedPaymentInfo) {
      this.removedPaymentInfo = removedPaymentInfo;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
