package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class OrderQuoteCommand {
  private ResourceIdentifierInput quote;

  private Long version;

  private Boolean quoteStateToAccepted = false;

  private PaymentState paymentState;

  private OrderState orderState;

  private ResourceIdentifierInput state;

  private ShipmentState shipmentState;

  private String orderNumber;

  private CustomFieldsDraft custom;

  public OrderQuoteCommand() {
  }

  public OrderQuoteCommand(ResourceIdentifierInput quote, Long version,
      Boolean quoteStateToAccepted, PaymentState paymentState, OrderState orderState,
      ResourceIdentifierInput state, ShipmentState shipmentState, String orderNumber,
      CustomFieldsDraft custom) {
    this.quote = quote;
    this.version = version;
    this.quoteStateToAccepted = quoteStateToAccepted;
    this.paymentState = paymentState;
    this.orderState = orderState;
    this.state = state;
    this.shipmentState = shipmentState;
    this.orderNumber = orderNumber;
    this.custom = custom;
  }

  public ResourceIdentifierInput getQuote() {
    return quote;
  }

  public void setQuote(ResourceIdentifierInput quote) {
    this.quote = quote;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public Boolean getQuoteStateToAccepted() {
    return quoteStateToAccepted;
  }

  public void setQuoteStateToAccepted(Boolean quoteStateToAccepted) {
    this.quoteStateToAccepted = quoteStateToAccepted;
  }

  public PaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(PaymentState paymentState) {
    this.paymentState = paymentState;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public ResourceIdentifierInput getState() {
    return state;
  }

  public void setState(ResourceIdentifierInput state) {
    this.state = state;
  }

  public ShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "OrderQuoteCommand{quote='" + quote + "', version='" + version + "', quoteStateToAccepted='" + quoteStateToAccepted + "', paymentState='" + paymentState + "', orderState='" + orderState + "', state='" + state + "', shipmentState='" + shipmentState + "', orderNumber='" + orderNumber + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderQuoteCommand that = (OrderQuoteCommand) o;
    return Objects.equals(quote, that.quote) &&
        Objects.equals(version, that.version) &&
        Objects.equals(quoteStateToAccepted, that.quoteStateToAccepted) &&
        Objects.equals(paymentState, that.paymentState) &&
        Objects.equals(orderState, that.orderState) &&
        Objects.equals(state, that.state) &&
        Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(orderNumber, that.orderNumber) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quote, version, quoteStateToAccepted, paymentState, orderState, state, shipmentState, orderNumber, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput quote;

    private Long version;

    private Boolean quoteStateToAccepted = false;

    private PaymentState paymentState;

    private OrderState orderState;

    private ResourceIdentifierInput state;

    private ShipmentState shipmentState;

    private String orderNumber;

    private CustomFieldsDraft custom;

    public OrderQuoteCommand build() {
      OrderQuoteCommand result = new OrderQuoteCommand();
      result.quote = this.quote;
      result.version = this.version;
      result.quoteStateToAccepted = this.quoteStateToAccepted;
      result.paymentState = this.paymentState;
      result.orderState = this.orderState;
      result.state = this.state;
      result.shipmentState = this.shipmentState;
      result.orderNumber = this.orderNumber;
      result.custom = this.custom;
      return result;
    }

    public Builder quote(ResourceIdentifierInput quote) {
      this.quote = quote;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder quoteStateToAccepted(Boolean quoteStateToAccepted) {
      this.quoteStateToAccepted = quoteStateToAccepted;
      return this;
    }

    public Builder paymentState(PaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }

    public Builder state(ResourceIdentifierInput state) {
      this.state = state;
      return this;
    }

    public Builder shipmentState(ShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
