package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderShippingContainerSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private ShippingContainer shippingContainer;

  private String type;

  public OrderShippingContainerSet() {
  }

  public OrderShippingContainerSet(ShippingContainer shippingContainer, String type) {
    this.shippingContainer = shippingContainer;
    this.type = type;
  }

  public ShippingContainer getShippingContainer() {
    return shippingContainer;
  }

  public void setShippingContainer(ShippingContainer shippingContainer) {
    this.shippingContainer = shippingContainer;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderShippingContainerSet{shippingContainer='" + shippingContainer + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderShippingContainerSet that = (OrderShippingContainerSet) o;
    return Objects.equals(shippingContainer, that.shippingContainer) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingContainer, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingContainer shippingContainer;

    private String type;

    public OrderShippingContainerSet build() {
      OrderShippingContainerSet result = new OrderShippingContainerSet();
      result.shippingContainer = this.shippingContainer;
      result.type = this.type;
      return result;
    }

    public Builder shippingContainer(ShippingContainer shippingContainer) {
      this.shippingContainer = shippingContainer;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
