package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderStateChanged implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String orderId;

  private OrderState orderState;

  private OrderState oldOrderState;

  private String type;

  public OrderStateChanged() {
  }

  public OrderStateChanged(String orderId, OrderState orderState, OrderState oldOrderState,
      String type) {
    this.orderId = orderId;
    this.orderState = orderState;
    this.oldOrderState = oldOrderState;
    this.type = type;
  }

  public String getOrderId() {
    return orderId;
  }

  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }

  public OrderState getOrderState() {
    return orderState;
  }

  public void setOrderState(OrderState orderState) {
    this.orderState = orderState;
  }

  public OrderState getOldOrderState() {
    return oldOrderState;
  }

  public void setOldOrderState(OrderState oldOrderState) {
    this.oldOrderState = oldOrderState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderStateChanged{orderId='" + orderId + "', orderState='" + orderState + "', oldOrderState='" + oldOrderState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderStateChanged that = (OrderStateChanged) o;
    return Objects.equals(orderId, that.orderId) &&
        Objects.equals(orderState, that.orderState) &&
        Objects.equals(oldOrderState, that.oldOrderState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderId, orderState, oldOrderState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String orderId;

    private OrderState orderState;

    private OrderState oldOrderState;

    private String type;

    public OrderStateChanged build() {
      OrderStateChanged result = new OrderStateChanged();
      result.orderId = this.orderId;
      result.orderState = this.orderState;
      result.oldOrderState = this.oldOrderState;
      result.type = this.type;
      return result;
    }

    public Builder orderId(String orderId) {
      this.orderId = orderId;
      return this;
    }

    public Builder orderState(OrderState orderState) {
      this.orderState = orderState;
      return this;
    }

    public Builder oldOrderState(OrderState oldOrderState) {
      this.oldOrderState = oldOrderState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
