package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class OrderStoreSet implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Store store;

  private Store oldStore;

  private KeyReference storeRef;

  private KeyReference oldStoreRef;

  private String type;

  public OrderStoreSet() {
  }

  public OrderStoreSet(Store store, Store oldStore, KeyReference storeRef, KeyReference oldStoreRef,
      String type) {
    this.store = store;
    this.oldStore = oldStore;
    this.storeRef = storeRef;
    this.oldStoreRef = oldStoreRef;
    this.type = type;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public Store getOldStore() {
    return oldStore;
  }

  public void setOldStore(Store oldStore) {
    this.oldStore = oldStore;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public KeyReference getOldStoreRef() {
    return oldStoreRef;
  }

  public void setOldStoreRef(KeyReference oldStoreRef) {
    this.oldStoreRef = oldStoreRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "OrderStoreSet{store='" + store + "', oldStore='" + oldStore + "', storeRef='" + storeRef + "', oldStoreRef='" + oldStoreRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderStoreSet that = (OrderStoreSet) o;
    return Objects.equals(store, that.store) &&
        Objects.equals(oldStore, that.oldStore) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(oldStoreRef, that.oldStoreRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(store, oldStore, storeRef, oldStoreRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Store store;

    private Store oldStore;

    private KeyReference storeRef;

    private KeyReference oldStoreRef;

    private String type;

    public OrderStoreSet build() {
      OrderStoreSet result = new OrderStoreSet();
      result.store = this.store;
      result.oldStore = this.oldStore;
      result.storeRef = this.storeRef;
      result.oldStoreRef = this.oldStoreRef;
      result.type = this.type;
      return result;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder oldStore(Store oldStore) {
      this.oldStore = oldStore;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder oldStoreRef(KeyReference oldStoreRef) {
      this.oldStoreRef = oldStoreRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
