package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ParcelAddedToDelivery implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private Delivery delivery;

  private Parcel parcel;

  private String shippingKey;

  private String type;

  public ParcelAddedToDelivery() {
  }

  public ParcelAddedToDelivery(Delivery delivery, Parcel parcel, String shippingKey, String type) {
    this.delivery = delivery;
    this.parcel = parcel;
    this.shippingKey = shippingKey;
    this.type = type;
  }

  public Delivery getDelivery() {
    return delivery;
  }

  public void setDelivery(Delivery delivery) {
    this.delivery = delivery;
  }

  public Parcel getParcel() {
    return parcel;
  }

  public void setParcel(Parcel parcel) {
    this.parcel = parcel;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ParcelAddedToDelivery{delivery='" + delivery + "', parcel='" + parcel + "', shippingKey='" + shippingKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelAddedToDelivery that = (ParcelAddedToDelivery) o;
    return Objects.equals(delivery, that.delivery) &&
        Objects.equals(parcel, that.parcel) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(delivery, parcel, shippingKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Delivery delivery;

    private Parcel parcel;

    private String shippingKey;

    private String type;

    public ParcelAddedToDelivery build() {
      ParcelAddedToDelivery result = new ParcelAddedToDelivery();
      result.delivery = this.delivery;
      result.parcel = this.parcel;
      result.shippingKey = this.shippingKey;
      result.type = this.type;
      return result;
    }

    public Builder delivery(Delivery delivery) {
      this.delivery = delivery;
      return this;
    }

    public Builder parcel(Parcel parcel) {
      this.parcel = parcel;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
