package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ParcelData {
  private String key;

  private ParcelMeasurements measurements;

  private TrackingData trackingData;

  private List<DeliveryItem> items;

  private CustomFieldsCommand custom;

  public ParcelData() {
  }

  public ParcelData(String key, ParcelMeasurements measurements, TrackingData trackingData,
      List<DeliveryItem> items, CustomFieldsCommand custom) {
    this.key = key;
    this.measurements = measurements;
    this.trackingData = trackingData;
    this.items = items;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ParcelMeasurements getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurements measurements) {
    this.measurements = measurements;
  }

  public TrackingData getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingData trackingData) {
    this.trackingData = trackingData;
  }

  public List<DeliveryItem> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItem> items) {
    this.items = items;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ParcelData{key='" + key + "', measurements='" + measurements + "', trackingData='" + trackingData + "', items='" + items + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelData that = (ParcelData) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(measurements, that.measurements) &&
        Objects.equals(trackingData, that.trackingData) &&
        Objects.equals(items, that.items) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, measurements, trackingData, items, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ParcelMeasurements measurements;

    private TrackingData trackingData;

    private List<DeliveryItem> items;

    private CustomFieldsCommand custom;

    public ParcelData build() {
      ParcelData result = new ParcelData();
      result.key = this.key;
      result.measurements = this.measurements;
      result.trackingData = this.trackingData;
      result.items = this.items;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder measurements(ParcelMeasurements measurements) {
      this.measurements = measurements;
      return this;
    }

    public Builder trackingData(TrackingData trackingData) {
      this.trackingData = trackingData;
      return this;
    }

    public Builder items(List<DeliveryItem> items) {
      this.items = items;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
