package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ParcelDataDraftType {
  private String key;

  private ParcelMeasurementsDraftType measurements;

  private TrackingDataDraftType trackingData;

  private List<DeliveryItemDraftType> items = Collections.emptyList();

  private CustomFieldsDraft custom;

  public ParcelDataDraftType() {
  }

  public ParcelDataDraftType(String key, ParcelMeasurementsDraftType measurements,
      TrackingDataDraftType trackingData, List<DeliveryItemDraftType> items,
      CustomFieldsDraft custom) {
    this.key = key;
    this.measurements = measurements;
    this.trackingData = trackingData;
    this.items = items;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ParcelMeasurementsDraftType getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurementsDraftType measurements) {
    this.measurements = measurements;
  }

  public TrackingDataDraftType getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingDataDraftType trackingData) {
    this.trackingData = trackingData;
  }

  public List<DeliveryItemDraftType> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItemDraftType> items) {
    this.items = items;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ParcelDataDraftType{key='" + key + "', measurements='" + measurements + "', trackingData='" + trackingData + "', items='" + items + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelDataDraftType that = (ParcelDataDraftType) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(measurements, that.measurements) &&
        Objects.equals(trackingData, that.trackingData) &&
        Objects.equals(items, that.items) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, measurements, trackingData, items, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ParcelMeasurementsDraftType measurements;

    private TrackingDataDraftType trackingData;

    private List<DeliveryItemDraftType> items = Collections.emptyList();

    private CustomFieldsDraft custom;

    public ParcelDataDraftType build() {
      ParcelDataDraftType result = new ParcelDataDraftType();
      result.key = this.key;
      result.measurements = this.measurements;
      result.trackingData = this.trackingData;
      result.items = this.items;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder measurements(ParcelMeasurementsDraftType measurements) {
      this.measurements = measurements;
      return this;
    }

    public Builder trackingData(TrackingDataDraftType trackingData) {
      this.trackingData = trackingData;
      return this;
    }

    public Builder items(List<DeliveryItemDraftType> items) {
      this.items = items;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
