package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ParcelDraft {
  private String id;

  private String key;

  private OffsetDateTime createdAt;

  private ParcelMeasurementsDraftType measurements;

  private TrackingDataDraftType trackingData;

  private List<DeliveryItemDraftType> items = Collections.emptyList();

  private CustomFieldsDraft custom;

  public ParcelDraft() {
  }

  public ParcelDraft(String id, String key, OffsetDateTime createdAt,
      ParcelMeasurementsDraftType measurements, TrackingDataDraftType trackingData,
      List<DeliveryItemDraftType> items, CustomFieldsDraft custom) {
    this.id = id;
    this.key = key;
    this.createdAt = createdAt;
    this.measurements = measurements;
    this.trackingData = trackingData;
    this.items = items;
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public ParcelMeasurementsDraftType getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurementsDraftType measurements) {
    this.measurements = measurements;
  }

  public TrackingDataDraftType getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingDataDraftType trackingData) {
    this.trackingData = trackingData;
  }

  public List<DeliveryItemDraftType> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItemDraftType> items) {
    this.items = items;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ParcelDraft{id='" + id + "', key='" + key + "', createdAt='" + createdAt + "', measurements='" + measurements + "', trackingData='" + trackingData + "', items='" + items + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelDraft that = (ParcelDraft) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(measurements, that.measurements) &&
        Objects.equals(trackingData, that.trackingData) &&
        Objects.equals(items, that.items) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, createdAt, measurements, trackingData, items, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private OffsetDateTime createdAt;

    private ParcelMeasurementsDraftType measurements;

    private TrackingDataDraftType trackingData;

    private List<DeliveryItemDraftType> items = Collections.emptyList();

    private CustomFieldsDraft custom;

    public ParcelDraft build() {
      ParcelDraft result = new ParcelDraft();
      result.id = this.id;
      result.key = this.key;
      result.createdAt = this.createdAt;
      result.measurements = this.measurements;
      result.trackingData = this.trackingData;
      result.items = this.items;
      result.custom = this.custom;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder measurements(ParcelMeasurementsDraftType measurements) {
      this.measurements = measurements;
      return this;
    }

    public Builder trackingData(TrackingDataDraftType trackingData) {
      this.trackingData = trackingData;
      return this;
    }

    public Builder items(List<DeliveryItemDraftType> items) {
      this.items = items;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
