package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ParcelMeasurementsUpdated implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String deliveryId;

  private String parcelId;

  private ParcelMeasurements measurements;

  private String shippingKey;

  private String type;

  public ParcelMeasurementsUpdated() {
  }

  public ParcelMeasurementsUpdated(String deliveryId, String parcelId,
      ParcelMeasurements measurements, String shippingKey, String type) {
    this.deliveryId = deliveryId;
    this.parcelId = parcelId;
    this.measurements = measurements;
    this.shippingKey = shippingKey;
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public ParcelMeasurements getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurements measurements) {
    this.measurements = measurements;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ParcelMeasurementsUpdated{deliveryId='" + deliveryId + "', parcelId='" + parcelId + "', measurements='" + measurements + "', shippingKey='" + shippingKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelMeasurementsUpdated that = (ParcelMeasurementsUpdated) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(measurements, that.measurements) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, parcelId, measurements, shippingKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private String parcelId;

    private ParcelMeasurements measurements;

    private String shippingKey;

    private String type;

    public ParcelMeasurementsUpdated build() {
      ParcelMeasurementsUpdated result = new ParcelMeasurementsUpdated();
      result.deliveryId = this.deliveryId;
      result.parcelId = this.parcelId;
      result.measurements = this.measurements;
      result.shippingKey = this.shippingKey;
      result.type = this.type;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder measurements(ParcelMeasurements measurements) {
      this.measurements = measurements;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
