package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ParcelRemovedFromDelivery implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private String deliveryId;

  private Parcel parcel;

  private String shippingKey;

  private String type;

  public ParcelRemovedFromDelivery() {
  }

  public ParcelRemovedFromDelivery(String deliveryId, Parcel parcel, String shippingKey,
      String type) {
    this.deliveryId = deliveryId;
    this.parcel = parcel;
    this.shippingKey = shippingKey;
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public Parcel getParcel() {
    return parcel;
  }

  public void setParcel(Parcel parcel) {
    this.parcel = parcel;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ParcelRemovedFromDelivery{deliveryId='" + deliveryId + "', parcel='" + parcel + "', shippingKey='" + shippingKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParcelRemovedFromDelivery that = (ParcelRemovedFromDelivery) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(parcel, that.parcel) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, parcel, shippingKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private Parcel parcel;

    private String shippingKey;

    private String type;

    public ParcelRemovedFromDelivery build() {
      ParcelRemovedFromDelivery result = new ParcelRemovedFromDelivery();
      result.deliveryId = this.deliveryId;
      result.parcel = this.parcel;
      result.shippingKey = this.shippingKey;
      result.type = this.type;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder parcel(Parcel parcel) {
      this.parcel = parcel;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
