package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CountOnCustomLineItemUnits.class, name = "CountOnCustomLineItemUnits"),
    @JsonSubTypes.Type(value = CountOnLineItemUnits.class, name = "CountOnLineItemUnits")
})
public interface PatternComponent {
  String getType();

  void setType(String type);
}
