package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * Payments hold information about the current state of receiving and/or refunding money.
 * [documentation](https://docs.commercetools.com/api/projects/payments)
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Payment implements com.commercetools.graphql.api.types.Versioned {
  private String key;

  private Reference customerRef;

  private Customer customer;

  private String anonymousId;

  private String interfaceId;

  private Money amountPlanned;

  private PaymentMethodInfo paymentMethodInfo;

  private PaymentStatus paymentStatus;

  private List<Transaction> transactions;

  private InterfaceInteractionsRawResult interfaceInteractionsRaw;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Payment() {
  }

  public Payment(String key, Reference customerRef, Customer customer, String anonymousId,
      String interfaceId, Money amountPlanned, PaymentMethodInfo paymentMethodInfo,
      PaymentStatus paymentStatus, List<Transaction> transactions,
      InterfaceInteractionsRawResult interfaceInteractionsRaw, CustomFieldsType custom, String id,
      Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.key = key;
    this.customerRef = customerRef;
    this.customer = customer;
    this.anonymousId = anonymousId;
    this.interfaceId = interfaceId;
    this.amountPlanned = amountPlanned;
    this.paymentMethodInfo = paymentMethodInfo;
    this.paymentStatus = paymentStatus;
    this.transactions = transactions;
    this.interfaceInteractionsRaw = interfaceInteractionsRaw;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public String getInterfaceId() {
    return interfaceId;
  }

  public void setInterfaceId(String interfaceId) {
    this.interfaceId = interfaceId;
  }

  public Money getAmountPlanned() {
    return amountPlanned;
  }

  public void setAmountPlanned(Money amountPlanned) {
    this.amountPlanned = amountPlanned;
  }

  public PaymentMethodInfo getPaymentMethodInfo() {
    return paymentMethodInfo;
  }

  public void setPaymentMethodInfo(PaymentMethodInfo paymentMethodInfo) {
    this.paymentMethodInfo = paymentMethodInfo;
  }

  public PaymentStatus getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(PaymentStatus paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  public List<Transaction> getTransactions() {
    return transactions;
  }

  public void setTransactions(List<Transaction> transactions) {
    this.transactions = transactions;
  }

  public InterfaceInteractionsRawResult getInterfaceInteractionsRaw() {
    return interfaceInteractionsRaw;
  }

  public void setInterfaceInteractionsRaw(InterfaceInteractionsRawResult interfaceInteractionsRaw) {
    this.interfaceInteractionsRaw = interfaceInteractionsRaw;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Payment{key='" + key + "', customerRef='" + customerRef + "', customer='" + customer + "', anonymousId='" + anonymousId + "', interfaceId='" + interfaceId + "', amountPlanned='" + amountPlanned + "', paymentMethodInfo='" + paymentMethodInfo + "', paymentStatus='" + paymentStatus + "', transactions='" + transactions + "', interfaceInteractionsRaw='" + interfaceInteractionsRaw + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Payment that = (Payment) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(interfaceId, that.interfaceId) &&
        Objects.equals(amountPlanned, that.amountPlanned) &&
        Objects.equals(paymentMethodInfo, that.paymentMethodInfo) &&
        Objects.equals(paymentStatus, that.paymentStatus) &&
        Objects.equals(transactions, that.transactions) &&
        Objects.equals(interfaceInteractionsRaw, that.interfaceInteractionsRaw) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, customerRef, customer, anonymousId, interfaceId, amountPlanned, paymentMethodInfo, paymentStatus, transactions, interfaceInteractionsRaw, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private Reference customerRef;

    private Customer customer;

    private String anonymousId;

    private String interfaceId;

    private Money amountPlanned;

    private PaymentMethodInfo paymentMethodInfo;

    private PaymentStatus paymentStatus;

    private List<Transaction> transactions;

    private InterfaceInteractionsRawResult interfaceInteractionsRaw;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Payment build() {
      Payment result = new Payment();
      result.key = this.key;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      result.anonymousId = this.anonymousId;
      result.interfaceId = this.interfaceId;
      result.amountPlanned = this.amountPlanned;
      result.paymentMethodInfo = this.paymentMethodInfo;
      result.paymentStatus = this.paymentStatus;
      result.transactions = this.transactions;
      result.interfaceInteractionsRaw = this.interfaceInteractionsRaw;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder interfaceId(String interfaceId) {
      this.interfaceId = interfaceId;
      return this;
    }

    public Builder amountPlanned(Money amountPlanned) {
      this.amountPlanned = amountPlanned;
      return this;
    }

    public Builder paymentMethodInfo(PaymentMethodInfo paymentMethodInfo) {
      this.paymentMethodInfo = paymentMethodInfo;
      return this;
    }

    public Builder paymentStatus(PaymentStatus paymentStatus) {
      this.paymentStatus = paymentStatus;
      return this;
    }

    public Builder transactions(List<Transaction> transactions) {
      this.transactions = transactions;
      return this;
    }

    public Builder interfaceInteractionsRaw(
        InterfaceInteractionsRawResult interfaceInteractionsRaw) {
      this.interfaceInteractionsRaw = interfaceInteractionsRaw;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
